/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.function.BooleanSupplier;

final class ServiceTalkHttp2FrameLogger
extends Http2FrameLogger {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final FixedLevelLogger logger;
    private final BooleanSupplier logUserDataSupplier;

    ServiceTalkHttp2FrameLogger(FixedLevelLogger logger, BooleanSupplier logUserDataSupplier) {
        super(io.netty.handler.logging.LogLevel.ERROR);
        this.logger = logger;
        this.logUserDataSupplier = logUserDataSupplier;
    }

    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    public void logData(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes(), this.toString(data)});
            } else {
                this.logger.log("{} {} DATA: streamId={} padding={} endStream={} length={}", new Object[]{ctx.channel(), direction.name(), streamId, padding, endStream, data.readableBytes()});
            }
        }
    }

    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} HEADERS: streamId={} headers={} padding={} endStream={}", new Object[]{ctx.channel(), direction.name(), streamId, this.toString(headers), padding, endStream});
        }
    }

    public void logHeaders(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", new Object[]{ctx.channel(), direction.name(), streamId, this.toString(headers), streamDependency, weight, exclusive, padding, endStream});
        }
    }

    public void logPriority(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", new Object[]{ctx.channel(), direction.name(), streamId, streamDependency, weight, exclusive});
        }
    }

    public void logRstStream(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} RST_STREAM: streamId={} errorCode={}", new Object[]{ctx.channel(), direction.name(), streamId, errorCode});
        }
    }

    public void logSettingsAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} SETTINGS: ack=true", (Object)ctx.channel(), (Object)direction.name());
        }
    }

    public void logSettings(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} SETTINGS: ack=false settings={}", new Object[]{ctx.channel(), direction.name(), settings.toString()});
        }
    }

    public void logPing(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PING: ack=false bytes={}", new Object[]{ctx.channel(), direction.name(), data});
        }
    }

    public void logPingAck(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, long data) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PING: ack=true bytes={}", new Object[]{ctx.channel(), direction.name(), data});
        }
    }

    public void logPushPromise(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", new Object[]{ctx.channel(), direction.name(), streamId, promisedStreamId, this.toString(headers), padding});
        }
    }

    public void logGoAway(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), lastStreamId, errorCode, debugData.readableBytes(), this.toString(debugData)});
            } else {
                this.logger.log("{} {} GO_AWAY: lastStreamId={} errorCode={} length={}", new Object[]{ctx.channel(), direction.name(), lastStreamId, errorCode, debugData.readableBytes()});
            }
        }
    }

    public void logWindowsUpdate(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        if (this.logger.isEnabled()) {
            this.logger.log("{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", new Object[]{ctx.channel(), direction.name(), streamId, windowSizeIncrement});
        }
    }

    public void logUnknownFrame(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.logger.isEnabled()) {
            if (this.logUserDataSupplier.getAsBoolean()) {
                this.logger.log("{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", new Object[]{ctx.channel(), direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data)});
            } else {
                this.logger.log("{} {} UNKNOWN: frameType={} streamId={} flags={} length={}", new Object[]{ctx.channel(), direction.name(), frameType & 0xFF, streamId, flags.value(), data.readableBytes()});
            }
        }
    }

    private String toString(Http2Headers headers) {
        return this.logUserDataSupplier.getAsBoolean() ? headers.toString() : String.valueOf(headers.size());
    }

    private String toString(ByteBuf buf) {
        if (this.logger.logLevel() == LogLevel.TRACE || buf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump((ByteBuf)buf);
        }
        return ByteBufUtil.hexDump((ByteBuf)buf, (int)buf.readerIndex(), (int)64) + "...";
    }
}

