/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ToPropertyDescriptorNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private JSToBooleanNode toBooleanNode;
    @CompilerDirectives.CompilationFinal
    private boolean wasExecuted;
    @Node.Child
    private PropertyGetNode getEnumerableNode;
    @Node.Child
    private PropertyGetNode getConfigurableNode;
    @Node.Child
    private PropertyGetNode getWritableNode;
    @Node.Child
    private PropertyGetNode getValueNode;
    @Node.Child
    private PropertyGetNode getSetNode;
    @Node.Child
    private PropertyGetNode getGetNode;
    @Node.Child
    private HasPropertyCacheNode hasEnumerableNode;
    @Node.Child
    private HasPropertyCacheNode hasConfigurableNode;
    @Node.Child
    private HasPropertyCacheNode hasWritableNode;
    @Node.Child
    private HasPropertyCacheNode hasValueNode;
    @Node.Child
    private HasPropertyCacheNode hasSetNode;
    @Node.Child
    private HasPropertyCacheNode hasGetNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    public abstract Object execute(Object var1);

    public static ToPropertyDescriptorNode create(JSContext context) {
        return ToPropertyDescriptorNodeGen.create(context);
    }

    protected ToPropertyDescriptorNode(JSContext context) {
        this.context = context;
        this.wasExecuted = context.isMultiContext();
    }

    private void initialize() {
        if (this.toBooleanNode == null || this.hasEnumerableNode == null || this.hasConfigurableNode == null || this.hasWritableNode == null || this.hasValueNode == null || this.hasGetNode == null || this.hasSetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toBooleanNode = (JSToBooleanNode)this.insert(JSToBooleanNode.create());
            this.hasEnumerableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.ENUMERABLE, this.context));
            this.hasConfigurableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.CONFIGURABLE, this.context));
            this.hasWritableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.WRITABLE, this.context));
            this.hasValueNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.VALUE, this.context));
            this.hasGetNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.GET, this.context));
            this.hasSetNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create(JSAttributes.SET, this.context));
        }
    }

    private boolean toBoolean(Object target) {
        return this.toBooleanNode.executeBoolean(target);
    }

    protected boolean wasExecuted(JSDynamicObject obj) {
        return this.wasExecuted;
    }

    @Specialization(guards={"!wasExecuted(obj)", "isJSObject(obj)"})
    protected Object nonSpecialized(JSDynamicObject obj) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.wasExecuted = true;
        return JSRuntime.toPropertyDescriptor((Object)obj);
    }

    @Specialization(guards={"wasExecuted(obj)", "isJSObject(obj)"})
    protected Object doDefault(JSDynamicObject obj, @Cached(value="create()") BranchProfile hasGetBranch, @Cached(value="create()") BranchProfile hasSetBranch, @Cached(value="create()") BranchProfile hasEnumerableBranch, @Cached(value="create()") BranchProfile hasConfigurableBranch, @Cached(value="create()") BranchProfile hasValueBranch, @Cached(value="create()") BranchProfile hasWritableBranch, @Cached(value="create()") IsCallableNode isCallable) {
        boolean hasSet;
        boolean hasGet;
        boolean hasWritable;
        boolean hasValue;
        this.initialize();
        PropertyDescriptor desc = PropertyDescriptor.createEmpty();
        if (this.hasEnumerableNode.hasProperty((Object)obj)) {
            hasEnumerableBranch.enter();
            desc.setEnumerable(this.getEnumerableValue(obj));
        }
        if (this.hasConfigurableNode.hasProperty((Object)obj)) {
            hasConfigurableBranch.enter();
            desc.setConfigurable(this.getConfigurableValue(obj));
        }
        if (hasValue = this.hasValueNode.hasProperty((Object)obj)) {
            hasValueBranch.enter();
            desc.setValue(this.getValue(obj));
        }
        if (hasWritable = this.hasWritableNode.hasProperty((Object)obj)) {
            hasWritableBranch.enter();
            desc.setWritable(this.getWritableValue(obj));
        }
        if (hasGet = this.hasGetNode.hasProperty((Object)obj)) {
            hasGetBranch.enter();
            Object getter = this.getGet(obj);
            if (!isCallable.executeBoolean(getter) && getter != Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Getter must be a function");
            }
            desc.setGet((JSDynamicObject)((Object)getter));
        }
        if (hasSet = this.hasSetNode.hasProperty((Object)obj)) {
            hasSetBranch.enter();
            Object setter = this.getSet(obj);
            if (!isCallable.executeBoolean(setter) && setter != Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Setter must be a function");
            }
            desc.setSet((JSDynamicObject)((Object)setter));
        }
        if ((hasGet || hasSet) && (hasValue || hasWritable)) {
            this.errorBranch.enter();
            throw Errors.createTypeError("Invalid property. A property cannot both have accessors and be writable or have a value");
        }
        return desc;
    }

    private Object getSet(JSDynamicObject obj) {
        if (this.getSetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getSetNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.SET, false, this.context));
        }
        return this.getSetNode.getValue((Object)obj);
    }

    private Object getGet(JSDynamicObject obj) {
        if (this.getGetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getGetNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.GET, false, this.context));
        }
        return this.getGetNode.getValue((Object)obj);
    }

    private Object getValue(JSDynamicObject obj) {
        if (this.getValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getValueNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.VALUE, false, this.context));
        }
        return this.getValueNode.getValue((Object)obj);
    }

    private boolean getWritableValue(JSDynamicObject obj) {
        if (this.getWritableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getWritableNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.WRITABLE, false, this.context));
        }
        return this.toBoolean(this.getWritableNode.getValue((Object)obj));
    }

    private boolean getConfigurableValue(JSDynamicObject obj) {
        if (this.getConfigurableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getConfigurableNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.CONFIGURABLE, false, this.context));
        }
        return this.toBoolean(this.getConfigurableNode.getValue((Object)obj));
    }

    private boolean getEnumerableValue(JSDynamicObject obj) {
        if (this.getEnumerableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getEnumerableNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSAttributes.ENUMERABLE, false, this.context));
        }
        return this.toBoolean(this.getEnumerableNode.getValue((Object)obj));
    }

    @Specialization(guards={"!isJSObject(obj)"})
    protected Object doNonObject(Object obj, @Cached JSToStringNode toStringNode, @Cached TruffleString.ConcatNode concatNode) {
        String message = this.context.isOptionV8CompatibilityMode() ? Strings.toJavaString(Strings.concat(concatNode, Strings.PROPERTY_DESCRIPTION_MUST_BE_AN_OBJECT, toStringNode.executeString(obj))) : "must be an object";
        throw Errors.createTypeError(message);
    }
}

