/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.AbstractBuffer;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.EmptyBuffer;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

final class ReadOnlyByteBuffer
extends AbstractBuffer {
    private final ByteBuffer buffer;

    ReadOnlyByteBuffer(ByteBuffer buffer) {
        super(buffer.position(), buffer.limit());
        this.buffer = buffer;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public Buffer capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int maxCapacity() {
        return this.capacity();
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public Buffer ensureWritable(int minWritableBytes) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return 1;
    }

    @Override
    protected byte getByteNoBounds(int index) {
        return this.buffer.get(index);
    }

    @Override
    protected short getShortNoBounds(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    protected int getIntNoBounds(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    protected long getLongNoBounds(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public Buffer getBytes(int index, Buffer dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes0(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), this.buffer.arrayOffset() + index, length);
        } else {
            dst.setBytes(dstIndex, (ByteBuffer)this.buffer.duplicate().position(index).limit(index + length));
        }
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        this.getBytes0(index, dst, dstIndex, length);
        return this;
    }

    private Buffer getBytes0(int index, byte[] dst, int dstIndex, int length) {
        if (this.buffer.hasArray()) {
            System.arraycopy(this.buffer.array(), this.buffer.arrayOffset() + index, dst, dstIndex, length);
        } else {
            ByteBuffer tmpBuf = this.buffer.duplicate();
            tmpBuf.position(index).limit(index + length);
            tmpBuf.get(dst, dstIndex, length);
        }
        return this;
    }

    @Override
    public Buffer getBytes(int index, ByteBuffer dst) {
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        this.checkIndex0(index, bytesToCopy);
        if (this.buffer.hasArray()) {
            dst.put(this.buffer.array(), this.buffer.arrayOffset() + index, bytesToCopy);
        } else {
            ByteBuffer tmpBuf = this.buffer.duplicate();
            tmpBuf.position(index).limit(index + bytesToCopy);
            dst.put(tmpBuf);
        }
        return this;
    }

    @Override
    public Buffer setBoolean(int index, boolean value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setShortLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setMediumLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setIntLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setLongLE(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setChar(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setFloat(int index, float value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setDouble(int index, double value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, Buffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, byte[] src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer setBytes(int index, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, InputStream src, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytesUntilEndStream(int index, InputStream src, int chunkSize) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBoolean(boolean value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeByte(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeShort(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeShortLE(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeMedium(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeMediumLE(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeInt(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeIntLE(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeLong(long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeLongLE(long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeChar(int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeFloat(float value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeDouble(double value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(Buffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(Buffer src, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(Buffer src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(byte[] src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBytes(ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int writeBytes(InputStream src, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int writeBytesUntilEndStream(InputStream src, int chunkSize) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeAscii(CharSequence seq) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUtf8(CharSequence seq) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUtf8(CharSequence seq, int ensureWritable) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeCharSequence(CharSequence seq, Charset charset) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer readSlice(int length) {
        this.checkReadableBytes0(length);
        ReadOnlyByteBuffer buf = new ReadOnlyByteBuffer(this.sliceByteBuffer0(this.readerIndex(), length));
        this.skipBytes0(length);
        return buf;
    }

    @Override
    public Buffer readBytes(int length) {
        if (length == 0) {
            return EmptyBuffer.EMPTY_BUFFER;
        }
        return this.readSlice(length);
    }

    @Override
    public Buffer copy(int index, int length) {
        return this.copy(this.sliceByteBuffer(index, length), length);
    }

    private Buffer copy(ByteBuffer byteBufferSlice, int length) {
        ByteBuffer tmpBuf = this.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        tmpBuf.put(byteBufferSlice);
        tmpBuf.flip();
        return new ReadOnlyByteBuffer(tmpBuf);
    }

    @Override
    public Buffer slice(int index, int length) {
        return new ReadOnlyByteBuffer(this.sliceByteBuffer(index, length));
    }

    private ByteBuffer sliceByteBuffer(int index, int length) {
        this.checkIndex0(index, length);
        return this.sliceByteBuffer0(index, length);
    }

    private ByteBuffer sliceByteBuffer0(int index, int length) {
        return (ByteBuffer)this.buffer.duplicate().position(index).limit(index + length);
    }

    @Override
    public Buffer duplicate() {
        return new ReadOnlyByteBuffer(this.sliceByteBuffer0(0, this.capacity()));
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer toNioBuffer() {
        return ReadOnlyByteBuffer.asReadOnlyByteBuffer(this.sliceByteBuffer0(this.readerIndex(), this.readableBytes()));
    }

    @Override
    public ByteBuffer toNioBuffer(int index, int length) {
        return ReadOnlyByteBuffer.asReadOnlyByteBuffer(this.sliceByteBuffer(index, length));
    }

    private static ByteBuffer asReadOnlyByteBuffer(ByteBuffer buffer) {
        return buffer.isReadOnly() ? buffer : buffer.asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer[] toNioBuffers(int index, int length) {
        return new ByteBuffer[]{this.toNioBuffer(index, length)};
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Buffer asReadOnly() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int arrayOffset() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        ByteBuffer slice = this.sliceByteBuffer(index, length);
        try {
            return charset.newDecoder().decode(slice).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

