/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.EllipsoidType;

public class TriaxialEllipsoid
extends Ellipsoid {
    private double semiMedianAxis;
    private String semiMedianAxisText;
    private double semiMinorAxis;
    private String semiMinorAxisText;

    public TriaxialEllipsoid() {
    }

    public TriaxialEllipsoid(String name, double semiMajorAxis, double semiMedianAxis, double semiMinorAxis) {
        this.setName(name);
        this.setSemiMajorAxis(semiMajorAxis);
        this.setSemiMedianAxis(semiMedianAxis);
        this.setSemiMinorAxis(semiMinorAxis);
    }

    public TriaxialEllipsoid(String name, String semiMajorAxis, String semiMedianAxis, String semiMinorAxis) {
        this.setName(name);
        this.setSemiMajorAxis(semiMajorAxis);
        this.setSemiMedianAxis(semiMedianAxis);
        this.setSemiMinorAxis(semiMinorAxis);
    }

    @Override
    public EllipsoidType getType() {
        return EllipsoidType.TRIAXIAL;
    }

    @Override
    public double getInverseFlattening() {
        throw new UnsupportedOperationException("Triaxial Ellipsoid does not support inverse flattening");
    }

    @Override
    public void setInverseFlattening(double inverseFlattening) {
        throw new UnsupportedOperationException("Triaxial Ellipsoid does not support inverse flattening");
    }

    public double getSemiMedianAxis() {
        return this.semiMedianAxis;
    }

    public String getSemiMedianAxisText() {
        return this.semiMedianAxisText;
    }

    public void setSemiMedianAxis(double semiMedianAxis) {
        this.semiMedianAxis = semiMedianAxis;
        this.semiMedianAxisText = String.valueOf(semiMedianAxis);
    }

    public void setSemiMedianAxis(String semiMedianAxis) {
        this.semiMedianAxisText = semiMedianAxis;
        this.semiMedianAxis = Double.parseDouble(semiMedianAxis);
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public String getSemiMinorAxisText() {
        return this.semiMinorAxisText;
    }

    public void setSemiMinorAxis(double semiMinorAxis) {
        this.semiMinorAxis = semiMinorAxis;
        this.semiMinorAxisText = String.valueOf(semiMinorAxis);
    }

    public void setSemiMinorAxis(String semiMinorAxis) {
        this.semiMinorAxisText = semiMinorAxis;
        this.semiMinorAxis = Double.parseDouble(semiMinorAxis);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.semiMedianAxis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.semiMinorAxis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriaxialEllipsoid other = (TriaxialEllipsoid)obj;
        if (Double.doubleToLongBits(this.semiMedianAxis) != Double.doubleToLongBits(other.semiMedianAxis)) {
            return false;
        }
        return Double.doubleToLongBits(this.semiMinorAxis) == Double.doubleToLongBits(other.semiMinorAxis);
    }
}

