/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.serializer.api.SerializerDeserializer;

public final class ByteArraySerializer
implements SerializerDeserializer<byte[]> {
    private static final SerializerDeserializer<byte[]> BYTE_SERIALIZER = new ByteArraySerializer(false);
    private static final SerializerDeserializer<byte[]> BYTE_SERIALIZER_COPY = new ByteArraySerializer(true);
    private final boolean forceCopy;

    private ByteArraySerializer(boolean forceCopy) {
        this.forceCopy = forceCopy;
    }

    public static SerializerDeserializer<byte[]> byteArraySerializer(boolean forceCopy) {
        return forceCopy ? BYTE_SERIALIZER_COPY : BYTE_SERIALIZER;
    }

    public byte[] deserialize(Buffer serializedData, BufferAllocator allocator) {
        byte[] result;
        if (!this.forceCopy && serializedData.hasArray() && serializedData.arrayOffset() == 0 && (result = serializedData.array()).length == serializedData.readableBytes()) {
            serializedData.skipBytes(result.length);
            return result;
        }
        result = new byte[serializedData.readableBytes()];
        serializedData.readBytes(result);
        return result;
    }

    public Buffer serialize(byte[] toSerialize, BufferAllocator allocator) {
        return allocator.wrap(toSerialize);
    }

    public void serialize(byte[] toSerialize, BufferAllocator allocator, Buffer buffer) {
        buffer.writeBytes(toSerialize);
    }
}

