/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.StreamingDeserializer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;

@Deprecated
abstract class AbstractJacksonDeserializer<T>
implements StreamingDeserializer<T> {
    private final Deque<JsonNode> nodeStack = new ArrayDeque<JsonNode>();
    private final ObjectReader reader;
    private final JsonParser parser;
    @Nullable
    private String fieldName;

    AbstractJacksonDeserializer(ObjectReader reader, JsonParser parser) {
        this.reader = reader;
        this.parser = parser;
    }

    public final Iterable<T> deserialize(Buffer toDeserialize) {
        try {
            return this.doDeserialize(toDeserialize, null);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public Iterable<T> deserialize(Iterable<Buffer> buffers) {
        ArrayList toReturn = new ArrayList(2);
        for (Buffer buffer : buffers) {
            try {
                this.doDeserialize(buffer, toReturn);
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }
        return toReturn;
    }

    public final boolean hasData() {
        return !this.nodeStack.isEmpty();
    }

    public void close() {
        if (this.hasData()) {
            throw new SerializationException("Left over data in the serializer on close.");
        }
    }

    abstract Iterable<T> doDeserialize(Buffer var1, @Nullable List<T> var2) throws IOException;

    final List<T> consumeParserTokens(@Nullable List<T> resultHolder) throws IOException {
        ArrayList<Object> toReturn;
        JsonToken token = this.parser.nextToken();
        if (token == JsonToken.NOT_AVAILABLE) {
            return resultHolder == null ? Collections.emptyList() : resultHolder;
        }
        ArrayList<Object> arrayList = toReturn = resultHolder == null ? new ArrayList<Object>(2) : resultHolder;
        do {
            JsonNode nextRoot;
            if ((nextRoot = this.push(token, this.parser)) == null) continue;
            toReturn.add(this.reader.readValue(nextRoot));
        } while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE);
        return toReturn;
    }

    @Nullable
    final JsonNode push(JsonToken event, JsonParser parser) throws IOException {
        switch (event) {
            case START_OBJECT: {
                this.nodeStack.push(this.createObject(this.nodeStack.peek()));
                return null;
            }
            case START_ARRAY: {
                this.nodeStack.push(this.createArray(this.nodeStack.peek()));
                return null;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                JsonNode top = this.nodeStack.pop();
                return this.nodeStack.isEmpty() ? top : null;
            }
            case FIELD_NAME: {
                assert (!this.nodeStack.isEmpty());
                this.fieldName = parser.getCurrentName();
                return null;
            }
            case VALUE_STRING: {
                if (this.nodeStack.isEmpty()) {
                    return new TextNode(parser.getValueAsString());
                }
                this.addValue(this.nodeStack.peek(), parser.getValueAsString());
                return null;
            }
            case VALUE_NUMBER_INT: {
                this.addValue(this.peekNonNull(), parser.getLongValue());
                return null;
            }
            case VALUE_NUMBER_FLOAT: {
                this.addValue(this.peekNonNull(), parser.getDoubleValue());
                return null;
            }
            case VALUE_TRUE: {
                if (this.nodeStack.isEmpty()) {
                    return BooleanNode.TRUE;
                }
                this.addValue(this.nodeStack.peek(), true);
                return null;
            }
            case VALUE_FALSE: {
                if (this.nodeStack.isEmpty()) {
                    return BooleanNode.FALSE;
                }
                this.addValue(this.nodeStack.peek(), false);
                return null;
            }
            case VALUE_NULL: {
                if (this.nodeStack.isEmpty()) {
                    return NullNode.getInstance();
                }
                this.addNull(this.nodeStack.peek());
                return null;
            }
        }
        throw new IllegalArgumentException("unsupported event: " + event);
    }

    private JsonNode peekNonNull() {
        JsonNode node = this.nodeStack.peek();
        assert (node != null);
        return node;
    }

    private JsonNode createObject(@Nullable JsonNode current) {
        if (current instanceof ObjectNode) {
            return ((ObjectNode)current).putObject(this.fieldName);
        }
        if (current instanceof ArrayNode) {
            return ((ArrayNode)current).addObject();
        }
        return JsonNodeFactory.instance.objectNode();
    }

    private JsonNode createArray(@Nullable JsonNode current) {
        if (current instanceof ObjectNode) {
            return ((ObjectNode)current).putArray(this.fieldName);
        }
        if (current instanceof ArrayNode) {
            return ((ArrayNode)current).addArray();
        }
        return JsonNodeFactory.instance.arrayNode();
    }

    private void addValue(JsonNode current, String s) {
        if (current instanceof ObjectNode) {
            ((ObjectNode)current).put(this.fieldName, s);
        } else {
            ((ArrayNode)current).add(s);
        }
    }

    private void addValue(JsonNode current, long v) {
        if (current instanceof ObjectNode) {
            ((ObjectNode)current).put(this.fieldName, v);
        } else {
            ((ArrayNode)current).add(v);
        }
    }

    private void addValue(JsonNode current, double v) {
        if (current instanceof ObjectNode) {
            ((ObjectNode)current).put(this.fieldName, v);
        } else {
            ((ArrayNode)current).add(v);
        }
    }

    private void addValue(JsonNode current, boolean v) {
        if (current instanceof ObjectNode) {
            ((ObjectNode)current).put(this.fieldName, v);
        } else {
            ((ArrayNode)current).add(v);
        }
    }

    private void addNull(JsonNode current) {
        if (current instanceof ObjectNode) {
            ((ObjectNode)current).putNull(this.fieldName);
        } else {
            ((ArrayNode)current).addNull();
        }
    }
}

