/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.BufferDecoder;
import io.servicetalk.encoding.api.BufferDecoderGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class BufferDecoderGroupBuilder {
    private static final char CONTENT_ENCODING_SEPARATOR = ',';
    private final StringBuilder messageEncoding;
    private final List<BufferDecoder> decoders;

    public BufferDecoderGroupBuilder() {
        this(2);
    }

    public BufferDecoderGroupBuilder(int decodersSizeEstimate) {
        this.messageEncoding = new StringBuilder(decodersSizeEstimate * 8);
        this.decoders = new ArrayList<BufferDecoder>(decodersSizeEstimate);
    }

    public BufferDecoderGroupBuilder add(BufferDecoder decoder) {
        return this.add(decoder, true);
    }

    public BufferDecoderGroupBuilder add(BufferDecoder decoder, boolean advertised) {
        this.decoders.add(decoder);
        if (advertised) {
            if (this.messageEncoding.length() > 0) {
                this.messageEncoding.append(',');
            }
            this.messageEncoding.append(decoder.encodingName());
        }
        return this;
    }

    public BufferDecoderGroup build() {
        return new BufferDecoderGroup(){
            private final List<BufferDecoder> bufferEncoders;
            @Nullable
            private final CharSequence advertisedMessageEncoding;
            {
                this.bufferEncoders = BufferDecoderGroupBuilder.this.decoders.isEmpty() ? Collections.emptyList() : new ArrayList(BufferDecoderGroupBuilder.this.decoders);
                this.advertisedMessageEncoding = BufferDecoderGroupBuilder.this.messageEncoding.length() == 0 ? null : CharSequences.newAsciiString((CharSequence)BufferDecoderGroupBuilder.this.messageEncoding);
            }

            @Override
            public List<BufferDecoder> decoders() {
                return this.bufferEncoders;
            }

            @Override
            @Nullable
            public CharSequence advertisedMessageEncoding() {
                return this.advertisedMessageEncoding;
            }
        };
    }
}

