/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.StreamingSerializer;
import java.util.Objects;
import java.util.function.ToIntFunction;

final class NonFramedStreamingSerializer<T>
implements StreamingSerializer<T> {
    private final Serializer<T> serializer;
    private final ToIntFunction<T> bytesEstimator;

    NonFramedStreamingSerializer(Serializer<T> serializer, ToIntFunction<T> bytesEstimator) {
        this.serializer = Objects.requireNonNull(serializer);
        this.bytesEstimator = Objects.requireNonNull(bytesEstimator);
    }

    public Publisher<Buffer> serialize(Publisher<T> toSerialize, BufferAllocator allocator) {
        return toSerialize.map(t -> {
            Buffer buffer = allocator.newBuffer(this.bytesEstimator.applyAsInt(t));
            this.serializer.serialize(t, allocator, buffer);
            return buffer;
        });
    }
}

