/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;

@Singleton
@Path(value="/")
public class TileResource {
    public static final String TILE_ENCODING = "gzip";
    public static final String TILE_TYPE = "application/vnd.mapbox-vector-tile";
    private final Supplier<TileStore> tileStoreSupplier;

    @Inject
    public TileResource(Supplier<TileStore> tileStoreSupplier) {
        this.tileStoreSupplier = tileStoreSupplier;
    }

    @GET
    @Path(value="/tiles/{z}/{x}/{y}.mvt")
    public Response getTile(@PathParam(value="z") int z, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        TileCoord tileCoord = new TileCoord(x, y, z);
        try {
            TileStore tileStore = this.tileStoreSupplier.get();
            ByteBuffer blob = tileStore.read(tileCoord);
            if (blob != null) {
                byte[] bytes = new byte[blob.remaining()];
                blob.get(bytes);
                return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)TILE_TYPE).header("Content-Encoding", (Object)TILE_ENCODING).entity((Object)bytes).build();
            }
            return Response.status((int)204).build();
        }
        catch (TileStoreException ex) {
            return Response.status((int)404).build();
        }
    }
}

