/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class GeocoderResource {
    private static final Logger logger = LoggerFactory.getLogger(GeocoderResource.class);
    private final SearcherManager searcherManager;

    @Inject
    public GeocoderResource(SearcherManager searcherManager) {
        this.searcherManager = searcherManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/api/geocoder")
    public Response searchLocations(@QueryParam(value="queryText") String queryText, @QueryParam(value="countryCode") @DefaultValue(value="") String countryCode, @QueryParam(value="limit") @DefaultValue(value="10") int limit) {
        if (queryText == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The queryText parameter is mandatory").build());
        }
        try {
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                Query query = new GeonamesQueryBuilder().queryText(queryText).countryCode(countryCode).scoringByPopulation().andOperator().build();
                TopDocs result = searcher.search(query, limit);
                List<GeocoderResult> results = Arrays.stream(result.scoreDocs).map(scoreDoc -> this.asResult(searcher, (ScoreDoc)scoreDoc)).toList();
                Response response = Response.status((Response.Status)Response.Status.OK).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)"application/json").entity((Object)new GeocoderResponse(results)).build();
                return response;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Illegal input while processing request", (Throwable)e);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            catch (IOException | ParseException e) {
                logger.error("Error while processing request", (Throwable)e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response;
            }
            finally {
                this.searcherManager.release((Object)searcher);
            }
        }
        catch (IOException e) {
            logger.error("Error while processing request", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private GeocoderResult asResult(IndexSearcher indexSearcher, ScoreDoc scoreDoc) {
        try {
            Document document = indexSearcher.doc(scoreDoc.doc);
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (IndexableField field : document.getFields()) {
                if (field.numericValue() != null) {
                    data.put(field.name(), field.numericValue());
                    continue;
                }
                if (field.stringValue() == null) continue;
                data.put(field.name(), field.stringValue());
            }
            return new GeocoderResult(scoreDoc.score, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    record GeocoderResponse(List<GeocoderResult> results) {
    }

    record GeocoderResult(float score, Map<String, Object> data) {
    }
}

