/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.compression;

import java.io.ByteArrayOutputStream;
import java.nio.ByteOrder;
import mil.nga.tiff.compression.CompressionDecoder;
import mil.nga.tiff.compression.CompressionEncoder;
import mil.nga.tiff.io.ByteReader;
import mil.nga.tiff.util.TiffException;

public class PackbitsCompression
implements CompressionDecoder,
CompressionEncoder {
    @Override
    public byte[] decode(byte[] bytes, ByteOrder byteOrder) {
        ByteReader reader = new ByteReader(bytes, byteOrder);
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream();
        while (reader.hasByte()) {
            int header = reader.readByte();
            if (header == -128) continue;
            if (header < 0) {
                short next = reader.readUnsignedByte();
                header = -header;
                for (int i = 0; i <= header; ++i) {
                    decodedStream.write(next);
                }
                continue;
            }
            for (int i = 0; i <= header; ++i) {
                decodedStream.write(reader.readUnsignedByte());
            }
        }
        byte[] decoded = decodedStream.toByteArray();
        return decoded;
    }

    @Override
    public boolean rowEncoding() {
        return true;
    }

    @Override
    public byte[] encode(byte[] bytes, ByteOrder byteOrder) {
        throw new TiffException("Packbits encoder is not yet implemented");
    }
}

