/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.router.jersey.JerseyRouteExecutionStrategy;
import io.servicetalk.http.router.jersey.JerseyRouteExecutionStrategyUtils;
import io.servicetalk.http.router.jersey.RouteStrategiesConfig;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.DelegatingConnectionContext;
import io.servicetalk.transport.api.DelegatingExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoThreadFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.server.AsyncContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;

@Priority(value=0x7FFFFFFF)
final class EndpointEnhancingRequestFilter
implements ContainerRequestFilter {
    private final EnhancedEndpointCache enhancedEndpointCache = new EnhancedEndpointCache();
    private final Provider<Ref<ConnectionContext>> ctxRefProvider;
    private final Provider<RouteStrategiesConfig> routeStrategiesConfigProvider;
    private final RequestScope requestScope;

    EndpointEnhancingRequestFilter(@Context Provider<Ref<ConnectionContext>> ctxRefProvider, @Context Provider<RouteStrategiesConfig> routeStrategiesConfigProvider, @Context RequestScope requestScope) {
        this.ctxRefProvider = Objects.requireNonNull(ctxRefProvider);
        this.routeStrategiesConfigProvider = Objects.requireNonNull(routeStrategiesConfigProvider);
        this.requestScope = Objects.requireNonNull(requestScope);
    }

    public void filter(ContainerRequestContext requestCtx) {
        if (((Ref)this.ctxRefProvider.get()).get() != null) {
            this.enhancedEndpointCache.enhance(this.requestScope, this.ctxRefProvider, this.routeStrategiesConfigProvider, (UriRoutingContext)requestCtx.getUriInfo());
        }
    }

    @Nullable
    private static HttpExecutionStrategy difference(io.servicetalk.concurrent.api.Executor contextExecutor, HttpExecutionStrategy left, HttpExecutionStrategy right) {
        io.servicetalk.concurrent.api.Executor rightExecutor;
        if (left.equals(right) || !right.hasOffloads()) {
            return null;
        }
        if (!left.hasOffloads()) {
            return right;
        }
        if (right instanceof JerseyRouteExecutionStrategy && (rightExecutor = ((JerseyRouteExecutionStrategy)right).executor()) != contextExecutor) {
            return new JerseyRouteExecutionStrategy(HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().build(), rightExecutor);
        }
        return null;
    }

    private static class NoopEnhancedEndpoint
    implements EnhancedEndpoint {
        private NoopEnhancedEndpoint() {
        }

        @Nullable
        public ContainerResponse apply(RequestProcessingContext requestProcessingContext) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Method getResourceMethod() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Class<?> getResourceClass() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ExecutorOverrideConnectionContext
    extends DelegatingConnectionContext {
        private final ExecutionContext<?> execCtx;

        private ExecutorOverrideConnectionContext(ConnectionContext original, final io.servicetalk.concurrent.api.Executor executor) {
            super(original);
            this.execCtx = new DelegatingExecutionContext(original.executionContext()){

                public io.servicetalk.concurrent.api.Executor executor() {
                    return executor;
                }
            };
        }

        public ExecutionContext<?> executionContext() {
            return this.execCtx;
        }
    }

    private static final class NestedParameterizedType
    implements ParameterizedType {
        private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
        private final Class<?> nestedClass;

        private NestedParameterizedType(Class<?> nestedClass) {
            this.nestedClass = nestedClass;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return EMPTY_TYPE_ARRAY;
        }

        @Override
        public Type getRawType() {
            return this.nestedClass;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }
    }

    private static final class SingleAwareEndpoint
    extends AbstractSourceAwareEndpoint<Single> {
        private SingleAwareEndpoint(Endpoint delegate, Class<?> resourceClass, Method resourceMethod, RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, @Nullable HttpExecutionStrategy routeExecutionStrategy) {
            super(delegate, resourceClass, resourceMethod, Single.class, requestScope, ctxRefProvider, routeExecutionStrategy);
        }

        @Override
        protected Single<Response> handleSourceResponse(Single source, ContainerResponse res) {
            return source.map(content -> {
                if (content instanceof Response) {
                    Response contentResponse = (Response)content;
                    if (!contentResponse.hasEntity()) {
                        return contentResponse;
                    }
                    OutboundJaxrsResponse jaxrsResponse = OutboundJaxrsResponse.from((Response)contentResponse);
                    OutboundMessageContext context = jaxrsResponse.getContext();
                    if (context.getEntityType() instanceof ParameterizedType) {
                        return jaxrsResponse;
                    }
                    context.setEntityType((Type)new NestedParameterizedType(context.getEntityClass()));
                    return new OutboundJaxrsResponse(jaxrsResponse.getStatusInfo(), context);
                }
                OutboundMessageContext requestContext = res.getWrappedMessageContext();
                if (content == null) {
                    requestContext.setEntity(null);
                    return new OutboundJaxrsResponse((Response.StatusType)Response.Status.NO_CONTENT, requestContext);
                }
                requestContext.setEntity(content);
                requestContext.setEntityType((Type)new NestedParameterizedType(content.getClass()));
                return new OutboundJaxrsResponse(res.getStatusInfo(), requestContext);
            });
        }
    }

    private static final class CompletableAwareEndpoint
    extends AbstractSourceAwareEndpoint<Completable> {
        private CompletableAwareEndpoint(Endpoint delegate, Class<?> resourceClass, Method resourceMethod, RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, @Nullable HttpExecutionStrategy routeExecutionStrategy) {
            super(delegate, resourceClass, resourceMethod, Completable.class, requestScope, ctxRefProvider, routeExecutionStrategy);
        }

        @Override
        protected Single<Response> handleSourceResponse(Completable source, ContainerResponse res) {
            return source.concat(Single.defer(() -> Single.succeeded((Object)Response.noContent().build())));
        }
    }

    private static abstract class AbstractSourceAwareEndpoint<T>
    extends AbstractWrappedEndpoint {
        private final Class<T> sourceType;

        private AbstractSourceAwareEndpoint(Endpoint delegate, Class<?> resourceClass, Method resourceMethod, Class<T> sourceType, RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, @Nullable HttpExecutionStrategy routeExecutionStrategy) {
            super(delegate, resourceClass, resourceMethod, requestScope, ctxRefProvider, routeExecutionStrategy);
            this.sourceType = sourceType;
        }

        @Override
        protected final Single<Response> handleContainerResponse(ContainerResponse res) {
            if (!res.hasEntity()) {
                return super.handleContainerResponse(res);
            }
            Object responseEntity = res.getEntity();
            return this.sourceType.isAssignableFrom(responseEntity.getClass()) ? this.handleSourceResponse(this.sourceType.cast(responseEntity), res) : super.handleContainerResponse(res);
        }

        protected abstract Single<Response> handleSourceResponse(T var1, ContainerResponse var2);
    }

    private static final class ExecutorOffloadingEndpoint
    extends AbstractWrappedEndpoint {
        private ExecutorOffloadingEndpoint(Endpoint delegate, Class<?> resourceClass, Method resourceMethod, RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, @Nullable HttpExecutionStrategy routeExecutionStrategy) {
            super(delegate, resourceClass, resourceMethod, requestScope, ctxRefProvider, routeExecutionStrategy);
        }
    }

    private static abstract class AbstractWrappedEndpoint
    implements EnhancedEndpoint {
        private final Endpoint delegate;
        private final Class<?> resourceClass;
        private final Method resourceMethod;
        private final RequestScope requestScope;
        @Nullable
        private final HttpExecutionStrategy routeExecutionStrategy;
        @Nullable
        private final HttpExecutionStrategy effectiveRouteStrategy;
        @Nullable
        private final io.servicetalk.concurrent.api.Executor executor;
        @Nullable
        private final Provider<Ref<ConnectionContext>> ctxRefProvider;

        private AbstractWrappedEndpoint(Endpoint delegate, Class<?> resourceClass, Method resourceMethod, RequestScope requestScope, @Nullable Provider<Ref<ConnectionContext>> ctxRefProvider, @Nullable HttpExecutionStrategy routeExecutionStrategy) {
            this.delegate = delegate;
            this.resourceClass = resourceClass;
            this.resourceMethod = resourceMethod;
            this.requestScope = requestScope;
            this.ctxRefProvider = ctxRefProvider;
            this.routeExecutionStrategy = routeExecutionStrategy;
            if (routeExecutionStrategy != null) {
                ExecutionContext executionContext = ((ConnectionContext)((Ref)ctxRefProvider.get()).get()).executionContext();
                ExecutionStrategy executionStrategy = executionContext.executionStrategy();
                this.executor = executionContext.executor();
                this.effectiveRouteStrategy = this.calculateEffectiveStrategy(executionStrategy, this.executor);
            } else {
                this.effectiveRouteStrategy = null;
                this.executor = null;
            }
        }

        public Class<?> getResourceClass() {
            return this.resourceClass;
        }

        public Method getResourceMethod() {
            return this.resourceMethod;
        }

        @Nullable
        public ContainerResponse apply(final RequestProcessingContext requestProcessingCtx) {
            Cancellable cancellable;
            final AsyncContext asyncContext = requestProcessingCtx.asyncContext();
            if (asyncContext.isSuspended()) {
                throw new IllegalStateException("JAX-RS suspended responses can't be used with " + this.getClass().getSimpleName());
            }
            if (!asyncContext.suspend()) {
                throw new IllegalStateException("Failed to suspend request processing");
            }
            Single responseSingle = this.callOriginalEndpoint(requestProcessingCtx, this.effectiveRouteStrategy).flatMap(this::handleContainerResponse).liftSync(subscriber -> new SingleSource.Subscriber<Response>(){

                public void onSubscribe(Cancellable cancellable) {
                    subscriber.onSubscribe(() -> {
                        cancellable.cancel();
                        this.restoreEndPoint();
                        asyncContext.cancel();
                    });
                }

                public void onSuccess(@Nullable Response result) {
                    this.restoreEndPoint();
                    subscriber.onSuccess((Object)result);
                }

                public void onError(Throwable t) {
                    this.restoreEndPoint();
                    subscriber.onError(t);
                    asyncContext.resume(t);
                }

                private void restoreEndPoint() {
                    requestProcessingCtx.routingContext().setEndpoint(delegate);
                }
            });
            if (this.effectiveRouteStrategy != null) {
                assert (this.executor != null);
                cancellable = (this.effectiveRouteStrategy.isSendOffloaded() ? responseSingle.subscribeOn((Executor)this.executor, IoThreadFactory.IoThread::currentThreadIsIoThread) : responseSingle).subscribe(arg_0 -> ((AsyncContext)asyncContext).resume(arg_0));
            } else {
                cancellable = responseSingle.subscribe(arg_0 -> ((AsyncContext)asyncContext).resume(arg_0));
            }
            RequestProperties.setRequestCancellable((Cancellable)cancellable, (ContainerRequestContext)requestProcessingCtx.request());
            return null;
        }

        @Nullable
        private HttpExecutionStrategy calculateEffectiveStrategy(@Nullable ExecutionStrategy executionStrategy, @Nullable io.servicetalk.concurrent.api.Executor executor) {
            assert (this.routeExecutionStrategy != null);
            if (executor != null && executionStrategy instanceof HttpExecutionStrategy) {
                return EndpointEnhancingRequestFilter.difference(executor, (HttpExecutionStrategy)executionStrategy, this.routeExecutionStrategy);
            }
            return null;
        }

        private Single<ContainerResponse> callOriginalEndpoint(RequestProcessingContext requestProcessingCtx, @Nullable HttpExecutionStrategy effectiveRouteStrategy) {
            io.servicetalk.concurrent.api.Executor useExecutor;
            if (effectiveRouteStrategy == null) {
                return Single.defer(() -> {
                    try {
                        return Single.succeeded((Object)this.delegate.apply((Object)requestProcessingCtx));
                    }
                    catch (Throwable t) {
                        return Single.failed((Throwable)t);
                    }
                });
            }
            RequestContext requestContext = this.requestScope.referenceCurrent();
            ContainerRequest request = requestProcessingCtx.request();
            assert (this.executor != null);
            assert (this.ctxRefProvider != null);
            Ref ctxRef = (Ref)this.ctxRefProvider.get();
            final Function<io.servicetalk.concurrent.api.Executor, ContainerResponse> service = actualExecutor -> (ContainerResponse)this.requestScope.runInScope(requestContext, () -> {
                ConnectionContext origConnectionContext = (ConnectionContext)ctxRef.get();
                if (!(origConnectionContext instanceof ExecutorOverrideConnectionContext)) {
                    ExecutorOverrideConnectionContext overrideConnectionContext = new ExecutorOverrideConnectionContext(origConnectionContext, (io.servicetalk.concurrent.api.Executor)actualExecutor);
                    ctxRef.set((Object)overrideConnectionContext);
                }
                RequestProperties.getRequestBufferPublisherInputStream((ContainerRequestContext)request).offloadSourcePublisher(effectiveRouteStrategy, actualExecutor);
                RequestProperties.setResponseExecutionStrategy((HttpExecutionStrategy)effectiveRouteStrategy, (ContainerRequestContext)request);
                return (ContainerResponse)this.delegate.apply((Object)requestProcessingCtx);
            });
            io.servicetalk.concurrent.api.Executor executor = useExecutor = effectiveRouteStrategy instanceof JerseyRouteExecutionStrategy ? ((JerseyRouteExecutionStrategy)effectiveRouteStrategy).executor() : this.executor;
            return (effectiveRouteStrategy.isMetadataReceiveOffloaded() ? useExecutor.submit(() -> (ContainerResponse)service.apply(useExecutor)) : new SubscribableSingle<ContainerResponse>(){

                protected void handleSubscribe(SingleSource.Subscriber<? super ContainerResponse> subscriber) {
                    ContainerResponse result;
                    try {
                        subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                    }
                    catch (Throwable cause) {
                        SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
                        return;
                    }
                    try {
                        result = (ContainerResponse)service.apply(useExecutor);
                    }
                    catch (Throwable t) {
                        subscriber.onError(t);
                        return;
                    }
                    subscriber.onSuccess((Object)result);
                }
            }).beforeFinally(() -> ((RequestContext)requestContext).release());
        }

        protected Single<Response> handleContainerResponse(ContainerResponse res) {
            return Single.succeeded((Object)new OutboundJaxrsResponse(res.getStatusInfo(), res.getWrappedMessageContext()));
        }
    }

    private static final class EnhancedEndpointCache {
        private static final EnhancedEndpoint NOOP = new NoopEnhancedEndpoint();
        private final ConcurrentHashMap<Method, EnhancedEndpoint> enhancements = new ConcurrentHashMap();

        private EnhancedEndpointCache() {
        }

        void enhance(RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, Provider<RouteStrategiesConfig> routeStrategiesConfigProvider, UriRoutingContext urc) {
            if (urc.getResourceMethod() == null) {
                return;
            }
            EnhancedEndpoint enhanced = this.enhancements.get(urc.getResourceMethod());
            if (enhanced == null) {
                enhanced = this.enhancements.computeIfAbsent(urc.getResourceMethod(), resourceMethod -> EnhancedEndpointCache.defineEndpoint(urc.getEndpoint(), requestScope, ctxRefProvider, routeStrategiesConfigProvider, urc.getResourceClass(), resourceMethod));
            }
            if (enhanced != NOOP) {
                urc.setEndpoint((Endpoint)enhanced);
            }
        }

        private static EnhancedEndpoint defineEndpoint(Endpoint delegate, RequestScope requestScope, Provider<Ref<ConnectionContext>> ctxRefProvider, Provider<RouteStrategiesConfig> routeStratConfigProvider, Class<?> resourceClass, Method resourceMethod) {
            HttpExecutionStrategy routeExecutionStrategy = JerseyRouteExecutionStrategyUtils.getRouteExecutionStrategy(resourceMethod, resourceClass, (RouteStrategiesConfig)routeStratConfigProvider.get());
            Class<?> returnType = resourceMethod.getReturnType();
            if (Single.class.isAssignableFrom(returnType)) {
                return new SingleAwareEndpoint(delegate, resourceClass, resourceMethod, requestScope, ctxRefProvider, routeExecutionStrategy);
            }
            if (Completable.class.isAssignableFrom(returnType)) {
                return new CompletableAwareEndpoint(delegate, resourceClass, resourceMethod, requestScope, ctxRefProvider, routeExecutionStrategy);
            }
            ExecutionContext executionContext = ((ConnectionContext)((Ref)ctxRefProvider.get()).get()).executionContext();
            HttpExecutionStrategy difference = EndpointEnhancingRequestFilter.difference(executionContext.executor(), (HttpExecutionStrategy)executionContext.executionStrategy(), routeExecutionStrategy);
            if (difference != null) {
                return new ExecutorOffloadingEndpoint(delegate, resourceClass, resourceMethod, requestScope, ctxRefProvider, routeExecutionStrategy);
            }
            return NOOP;
        }
    }

    private static interface EnhancedEndpoint
    extends Endpoint,
    ResourceInfo {
    }
}

