/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.function.BiConsumer;

final class ContextPreservingBiConsumer<T, U>
implements BiConsumer<T, U> {
    private final ContextMap saved;
    private final BiConsumer<T, U> delegate;

    ContextPreservingBiConsumer(BiConsumer<T, U> delegate, ContextMap contextMap) {
        this.saved = Objects.requireNonNull(contextMap);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T t, U u) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                this.delegate.accept(t, u);
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        } else {
            this.slowPath(t, u);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slowPath(T t, U u) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            this.delegate.accept(t, u);
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

