/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class CompletableDoOnUtils {
    private CompletableDoOnUtils() {
    }

    static Supplier<CompletableSource.Subscriber> doOnSubscribeSupplier(final Consumer<Cancellable> onSubscribe) {
        Objects.requireNonNull(onSubscribe);
        CompletableSource.Subscriber subscriber = new CompletableSource.Subscriber(){

            public void onSubscribe(Cancellable cancellable) {
                onSubscribe.accept(cancellable);
            }

            public void onComplete() {
            }

            public void onError(Throwable t) {
            }
        };
        return () -> subscriber;
    }

    static Supplier<CompletableSource.Subscriber> doOnCompleteSupplier(final Runnable onComplete) {
        Objects.requireNonNull(onComplete);
        CompletableSource.Subscriber subscriber = new CompletableSource.Subscriber(){

            public void onSubscribe(Cancellable cancellable) {
            }

            public void onComplete() {
                onComplete.run();
            }

            public void onError(Throwable t) {
            }
        };
        return () -> subscriber;
    }

    static Supplier<CompletableSource.Subscriber> doOnErrorSupplier(final Consumer<Throwable> onError) {
        Objects.requireNonNull(onError);
        CompletableSource.Subscriber subscriber = new CompletableSource.Subscriber(){

            public void onSubscribe(Cancellable cancellable) {
            }

            public void onComplete() {
            }

            public void onError(Throwable t) {
                onError.accept(t);
            }
        };
        return () -> subscriber;
    }
}

