/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.serializer.utils.FramedDeserializerOperator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public final class VarIntLengthStreamingSerializer<T>
implements StreamingSerializerDeserializer<T> {
    static final int ONE_BYTE_VAL = 128;
    static final int TWO_BYTE_VAL = 16384;
    static final int THREE_BYTE_VAL = 0x200000;
    static final int FOUR_BYTE_VAL = 0x10000000;
    static final int MAX_LENGTH_BYTES = 5;
    private final SerializerDeserializer<T> serializer;
    private final ToIntFunction<T> bytesEstimator;

    public VarIntLengthStreamingSerializer(SerializerDeserializer<T> serializer, ToIntFunction<T> bytesEstimator) {
        this.serializer = Objects.requireNonNull(serializer);
        this.bytesEstimator = Objects.requireNonNull(bytesEstimator);
    }

    public Publisher<T> deserialize(Publisher<Buffer> serializedData, BufferAllocator allocator) {
        return serializedData.liftSync(new FramedDeserializerOperator<T>(this.serializer, () -> new LengthDeframer(), allocator)).flatMapConcatIterable(Function.identity());
    }

    public Publisher<Buffer> serialize(Publisher<T> toSerialize, BufferAllocator allocator) {
        return toSerialize.map(t -> {
            Buffer buffer = allocator.newBuffer(5 + this.bytesEstimator.applyAsInt(t));
            int beforeWriterIndex = buffer.writerIndex();
            buffer.writerIndex(beforeWriterIndex + 5);
            this.serializer.serialize(t, allocator, buffer);
            int length = buffer.writerIndex() - beforeWriterIndex - 5;
            VarIntLengthStreamingSerializer.setVarInt(length, buffer, beforeWriterIndex);
            return buffer;
        });
    }

    static int getVarInt(Buffer buffer) {
        int i;
        int maxBytesToInspect = Math.min(5, buffer.readableBytes());
        int readerIndex = buffer.readerIndex();
        for (i = 0; i < maxBytesToInspect; ++i) {
            byte b = buffer.getByte(i + readerIndex);
            if ((b & 0x80) != 0) continue;
            if (i == 0) {
                return buffer.readByte();
            }
            if (i == 1) {
                short varInt = buffer.readShort();
                return (varInt & 0x7F) << 7 | (varInt & 0x7F00) >> 8;
            }
            if (i == 2) {
                int varInt = buffer.readMedium();
                return (varInt & 0x7F) << 14 | (varInt & 0x7F00) >> 1 | (varInt & 0x7F0000) >> 16;
            }
            if (i == 3) {
                int varInt = buffer.readInt();
                return (varInt & 0x7F) << 21 | (varInt & 0x7F00) << 6 | (varInt & 0x7F0000) >> 9 | (varInt & 0x7F000000) >> 24;
            }
            assert (i == 4);
            byte b0 = buffer.readByte();
            int varInt = buffer.readInt();
            if ((varInt & 0xF8) != 0) {
                throw new SerializationException("java int cannot support larger than 2147483647");
            }
            return (varInt & 7) << 28 | (varInt & 0x7F00) << 13 | (varInt & 0x7F0000) >> 2 | (varInt & 0x7F000000) >> 17 | b0 & 0x7F;
        }
        if (i == 5) {
            throw new SerializationException("java int cannot support more than 5 bytes of VarInt");
        }
        return -1;
    }

    static void setVarInt(int val, Buffer buffer, int index) {
        assert (val >= 0);
        if (val < 128) {
            buffer.setByte(index + 4, (int)((byte)val)).skipBytes(4);
        } else if (val < 16384) {
            int varIntEncoded = 0x8000 | (val & 0x7F) << 8 | (val & 0x3F80) >> 7;
            buffer.setShort(index + 3, varIntEncoded).skipBytes(3);
        } else if (val < 0x200000) {
            int varIntEncoded = 0x800000 | (val & 0x7F) << 16 | 0x8000 | (val & 0x3F80) << 1 | (val & 0x1FC000) >> 14;
            buffer.setMedium(index + 2, varIntEncoded).skipBytes(2);
        } else if (val < 0x10000000) {
            int varIntEncoded = Integer.MIN_VALUE | (val & 0x7F) << 24 | 0x800000 | (val & 0x3F80) << 9 | 0x8000 | (val & 0x1FC000) >> 6 | (val & 0xFE00000) >> 21;
            buffer.setInt(index + 1, varIntEncoded).skipBytes(1);
        } else {
            buffer.setByte(index, 0x80 | val & 0x7F);
            int varIntEncoded = Integer.MIN_VALUE | (val & 0x3F80) << 17 | 0x800000 | (val & 0x1FC000) << 2 | 0x8000 | (val & 0xFE00000) >> 13 | (val & 0xF0000000) >> 28;
            buffer.setInt(index + 1, varIntEncoded);
        }
    }

    private static final class LengthDeframer
    implements BiFunction<Buffer, BufferAllocator, Buffer> {
        private int expectedLength = -1;

        private LengthDeframer() {
        }

        @Override
        @Nullable
        public Buffer apply(Buffer buffer, BufferAllocator allocator) {
            if (this.expectedLength < 0) {
                this.expectedLength = VarIntLengthStreamingSerializer.getVarInt(buffer);
                if (this.expectedLength < 0) {
                    return null;
                }
            }
            if (buffer.readableBytes() < this.expectedLength) {
                return null;
            }
            Buffer result = buffer.readBytes(this.expectedLength);
            this.expectedLength = -1;
            return result;
        }
    }
}

