/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkt;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.SFException;

public class GeometryWriter {
    private Writer writer;

    public static String writeGeometry(Geometry geometry) throws IOException {
        String text = null;
        try (GeometryWriter writer = new GeometryWriter();){
            writer.write(geometry);
            text = writer.toString();
        }
        return text;
    }

    public GeometryWriter() {
        this(new StringWriter());
    }

    public GeometryWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.writer.toString();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Geometry geometry) throws IOException {
        GeometryType geometryType = geometry.getGeometryType();
        this.writer.write(geometryType.name());
        this.writer.write(" ");
        boolean hasZ = geometry.hasZ();
        boolean hasM = geometry.hasM();
        if (hasZ || hasM) {
            if (hasZ) {
                this.writer.write("Z");
            }
            if (hasM) {
                this.writer.write("M");
            }
            this.writer.write(" ");
        }
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                this.writePointText((Point)geometry);
                break;
            }
            case LINESTRING: {
                this.writeLineString((LineString)geometry);
                break;
            }
            case POLYGON: {
                this.writePolygon((Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                this.writeMultiPoint((MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                this.writeMultiLineString((MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                this.writeMultiPolygon((MultiPolygon)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                this.writeGeometryCollection((GeometryCollection)geometry);
                break;
            }
            case CIRCULARSTRING: {
                this.writeCircularString((CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                this.writeCompoundCurve((CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                this.writeCurvePolygon((CurvePolygon)geometry);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                this.writePolyhedralSurface((PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                this.writeTIN((TIN)geometry);
                break;
            }
            case TRIANGLE: {
                this.writeTriangle((Triangle)geometry);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
    }

    public void writePointText(Point point) throws IOException {
        this.writer.write("(");
        this.writePoint(point);
        this.writer.write(")");
    }

    public void writePoint(Point point) throws IOException {
        this.writeXY(point);
        this.writeZ(point);
        this.writeM(point);
    }

    public void writeXY(Point point) throws IOException {
        this.writer.write(Double.toString(point.getX()));
        this.writer.write(" ");
        this.writer.write(Double.toString(point.getY()));
    }

    public void writeZ(Point point) throws IOException {
        if (point.hasZ()) {
            this.writer.write(" ");
            this.writer.write(Double.toString(point.getZ()));
        }
    }

    public void writeM(Point point) throws IOException {
        if (point.hasM()) {
            this.writer.write(" ");
            this.writer.write(Double.toString(point.getM()));
        }
    }

    public void writeLineString(LineString lineString) throws IOException {
        if (lineString.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < lineString.numPoints(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePoint(lineString.getPoint(i));
            }
            this.writer.write(")");
        }
    }

    public void writePolygon(Polygon polygon) throws IOException {
        if (polygon.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < polygon.numRings(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writeLineString((LineString)polygon.getRing(i));
            }
            this.writer.write(")");
        }
    }

    public void writeMultiPoint(MultiPoint multiPoint) throws IOException {
        if (multiPoint.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < multiPoint.numPoints(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePointText(multiPoint.getPoint(i));
            }
            this.writer.write(")");
        }
    }

    public void writeMultiLineString(MultiLineString multiLineString) throws IOException {
        if (multiLineString.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < multiLineString.numLineStrings(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writeLineString(multiLineString.getLineString(i));
            }
            this.writer.write(")");
        }
    }

    public void writeMultiPolygon(MultiPolygon multiPolygon) throws IOException {
        if (multiPolygon.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < multiPolygon.numPolygons(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePolygon(multiPolygon.getPolygon(i));
            }
            this.writer.write(")");
        }
    }

    public void writeGeometryCollection(GeometryCollection<?> geometryCollection) throws IOException {
        if (geometryCollection.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < geometryCollection.numGeometries(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.write(geometryCollection.getGeometry(i));
            }
            this.writer.write(")");
        }
    }

    public void writeCircularString(CircularString circularString) throws IOException {
        if (circularString.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < circularString.numPoints(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePoint(circularString.getPoint(i));
            }
            this.writer.write(")");
        }
    }

    public void writeCompoundCurve(CompoundCurve compoundCurve) throws IOException {
        if (compoundCurve.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < compoundCurve.numLineStrings(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.write((Geometry)compoundCurve.getLineString(i));
            }
            this.writer.write(")");
        }
    }

    public void writeCurvePolygon(CurvePolygon<?> curvePolygon) throws IOException {
        if (curvePolygon.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < curvePolygon.numRings(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.write((Geometry)curvePolygon.getRing(i));
            }
            this.writer.write(")");
        }
    }

    public void writePolyhedralSurface(PolyhedralSurface polyhedralSurface) throws IOException {
        if (polyhedralSurface.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < polyhedralSurface.numPolygons(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePolygon(polyhedralSurface.getPolygon(i));
            }
            this.writer.write(")");
        }
    }

    public void writeTIN(TIN tin) throws IOException {
        if (tin.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < tin.numPolygons(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writePolygon(tin.getPolygon(i));
            }
            this.writer.write(")");
        }
    }

    public void writeTriangle(Triangle triangle) throws IOException {
        if (triangle.isEmpty()) {
            GeometryWriter.writeEmpty(this.writer);
        } else {
            this.writer.write("(");
            for (int i = 0; i < triangle.numRings(); ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writeLineString((LineString)triangle.getRing(i));
            }
            this.writer.write(")");
        }
    }

    public static void writeGeometry(Writer writer, Geometry geometry) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.write(geometry);
    }

    public static void writePointText(Writer writer, Point point) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePointText(point);
    }

    public static void writePoint(Writer writer, Point point) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePoint(point);
    }

    public static void writeLineString(Writer writer, LineString lineString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeLineString(lineString);
    }

    public static void writePolygon(Writer writer, Polygon polygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePolygon(polygon);
    }

    public static void writeMultiPoint(Writer writer, MultiPoint multiPoint) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiPoint(multiPoint);
    }

    public static void writeMultiLineString(Writer writer, MultiLineString multiLineString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiLineString(multiLineString);
    }

    public static void writeMultiPolygon(Writer writer, MultiPolygon multiPolygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiPolygon(multiPolygon);
    }

    public static void writeGeometryCollection(Writer writer, GeometryCollection<?> geometryCollection) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeGeometryCollection(geometryCollection);
    }

    public static void writeCircularString(Writer writer, CircularString circularString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCircularString(circularString);
    }

    public static void writeCompoundCurve(Writer writer, CompoundCurve compoundCurve) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCompoundCurve(compoundCurve);
    }

    public static void writeCurvePolygon(Writer writer, CurvePolygon<?> curvePolygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCurvePolygon(curvePolygon);
    }

    public static void writePolyhedralSurface(Writer writer, PolyhedralSurface polyhedralSurface) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePolyhedralSurface(polyhedralSurface);
    }

    public static void writeTIN(Writer writer, TIN tin) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeTIN(tin);
    }

    public static void writeTriangle(Writer writer, Triangle triangle) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeTriangle(triangle);
    }

    private static void writeEmpty(Writer writer) throws IOException {
        writer.write("EMPTY");
    }
}

