/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkt;

import java.io.IOException;
import java.util.Locale;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.Surface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.SFException;
import mil.nga.sf.util.TextReader;
import mil.nga.sf.util.filter.GeometryFilter;
import mil.nga.sf.wkt.GeometryTypeInfo;

public class GeometryReader {
    private TextReader reader;

    public static Geometry readGeometry(String text) throws IOException {
        return GeometryReader.readGeometry(text, null, null);
    }

    public static Geometry readGeometry(String text, GeometryFilter filter) throws IOException {
        return GeometryReader.readGeometry(text, filter, null);
    }

    public static <T extends Geometry> T readGeometry(String text, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(text, null, expectedType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Geometry> T readGeometry(String text, GeometryFilter filter, Class<T> expectedType) throws IOException {
        T geometry = null;
        try (GeometryReader reader = new GeometryReader(text);){
            geometry = reader.read(filter, expectedType);
        }
        return geometry;
    }

    public GeometryReader(String text) {
        this(new TextReader(text));
    }

    public GeometryReader(TextReader reader) {
        this.reader = reader;
    }

    public TextReader getTextReader() {
        return this.reader;
    }

    public void close() {
        this.reader.close();
    }

    public Geometry read() throws IOException {
        return this.read(null, null);
    }

    public Geometry read(GeometryFilter filter) throws IOException {
        return this.read(filter, null);
    }

    public <T extends Geometry> T read(Class<T> expectedType) throws IOException {
        return this.read(null, expectedType);
    }

    public <T extends Geometry> T read(GeometryFilter filter, Class<T> expectedType) throws IOException {
        return this.read(filter, null, expectedType);
    }

    public <T extends Geometry> T read(GeometryFilter filter, GeometryType containingType, Class<T> expectedType) throws IOException {
        PolyhedralSurface geometry = null;
        GeometryTypeInfo geometryTypeInfo = this.readGeometryType();
        if (geometryTypeInfo != null) {
            GeometryType geometryType = geometryTypeInfo.getGeometryType();
            boolean hasZ = geometryTypeInfo.hasZ();
            boolean hasM = geometryTypeInfo.hasM();
            switch (geometryType) {
                case GEOMETRY: {
                    throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
                }
                case POINT: {
                    geometry = this.readPointText(hasZ, hasM);
                    break;
                }
                case LINESTRING: {
                    geometry = this.readLineString(filter, hasZ, hasM);
                    break;
                }
                case POLYGON: {
                    geometry = this.readPolygon(filter, hasZ, hasM);
                    break;
                }
                case MULTIPOINT: {
                    geometry = this.readMultiPoint(filter, hasZ, hasM);
                    break;
                }
                case MULTILINESTRING: {
                    geometry = this.readMultiLineString(filter, hasZ, hasM);
                    break;
                }
                case MULTIPOLYGON: {
                    geometry = this.readMultiPolygon(filter, hasZ, hasM);
                    break;
                }
                case GEOMETRYCOLLECTION: {
                    geometry = this.readGeometryCollection(filter, hasZ, hasM);
                    break;
                }
                case MULTICURVE: {
                    geometry = this.readMultiCurve(filter, hasZ, hasM);
                    break;
                }
                case MULTISURFACE: {
                    geometry = this.readMultiSurface(filter, hasZ, hasM);
                    break;
                }
                case CIRCULARSTRING: {
                    geometry = this.readCircularString(filter, hasZ, hasM);
                    break;
                }
                case COMPOUNDCURVE: {
                    geometry = this.readCompoundCurve(filter, hasZ, hasM);
                    break;
                }
                case CURVEPOLYGON: {
                    geometry = this.readCurvePolygon(filter, hasZ, hasM);
                    break;
                }
                case CURVE: {
                    throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
                }
                case SURFACE: {
                    throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
                }
                case POLYHEDRALSURFACE: {
                    geometry = this.readPolyhedralSurface(filter, hasZ, hasM);
                    break;
                }
                case TIN: {
                    geometry = this.readTIN(filter, hasZ, hasM);
                    break;
                }
                case TRIANGLE: {
                    geometry = this.readTriangle(filter, hasZ, hasM);
                    break;
                }
                default: {
                    throw new SFException("Geometry Type not supported: " + geometryType);
                }
            }
            if (!GeometryReader.filter(filter, containingType, (Geometry)geometry)) {
                geometry = null;
            }
            if (expectedType != null && geometry != null && !expectedType.isAssignableFrom(geometry.getClass())) {
                throw new SFException("Unexpected Geometry Type. Expected: " + expectedType.getSimpleName() + ", Actual: " + geometry.getClass().getSimpleName());
            }
        }
        PolyhedralSurface result = geometry;
        return (T)result;
    }

    public GeometryTypeInfo readGeometryType() throws IOException {
        GeometryTypeInfo geometryInfo = null;
        String geometryTypeValue = this.reader.readToken();
        if (geometryTypeValue != null && !geometryTypeValue.equalsIgnoreCase("EMPTY")) {
            boolean hasZ = false;
            boolean hasM = false;
            GeometryType geometryType = GeometryType.findName((String)geometryTypeValue);
            if (geometryType == null) {
                String geomType = geometryTypeValue.toUpperCase(Locale.US);
                if (geomType.endsWith("Z")) {
                    hasZ = true;
                } else if (geomType.endsWith("M")) {
                    hasM = true;
                    if (geomType.endsWith("ZM")) {
                        hasZ = true;
                    }
                }
                int suffixSize = 0;
                if (hasZ) {
                    ++suffixSize;
                }
                if (hasM) {
                    ++suffixSize;
                }
                if (suffixSize > 0) {
                    geomType = geometryTypeValue.substring(0, geometryTypeValue.length() - suffixSize);
                    geometryType = GeometryType.findName((String)geomType);
                }
                if (geometryType == null) {
                    throw new SFException("Expected a valid geometry type, found: '" + geometryTypeValue + "'");
                }
            }
            if (!hasZ && !hasM) {
                String next = this.reader.peekToken();
                switch (GeometryReader.toUpperCase(next)) {
                    case "Z": {
                        hasZ = true;
                        break;
                    }
                    case "M": {
                        hasM = true;
                        break;
                    }
                    case "ZM": {
                        hasZ = true;
                        hasM = true;
                        break;
                    }
                    case "(": 
                    case "EMPTY": {
                        break;
                    }
                    default: {
                        throw new SFException("Invalid value following geometry type: '" + geometryTypeValue + "', value: '" + next + "'");
                    }
                }
                if (hasZ || hasM) {
                    this.reader.readToken();
                }
            }
            geometryInfo = new GeometryTypeInfo(geometryType, hasZ, hasM);
        }
        return geometryInfo;
    }

    public Point readPointText(boolean hasZ, boolean hasM) throws IOException {
        Point point = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            point = this.readPoint(hasZ, hasM);
            GeometryReader.rightParenthesis(this.reader);
        }
        return point;
    }

    public Point readPoint(boolean hasZ, boolean hasM) throws IOException {
        double x = this.reader.readDouble();
        double y = this.reader.readDouble();
        Point point = new Point(hasZ, hasM, x, y);
        if (hasZ || hasM) {
            if (hasZ) {
                point.setZ(Double.valueOf(this.reader.readDouble()));
            }
            if (hasM) {
                point.setM(Double.valueOf(this.reader.readDouble()));
            }
        } else if (!GeometryReader.isCommaOrRightParenthesis(this.reader)) {
            point.setZ(Double.valueOf(this.reader.readDouble()));
            if (!GeometryReader.isCommaOrRightParenthesis(this.reader)) {
                point.setM(Double.valueOf(this.reader.readDouble()));
            }
        }
        return point;
    }

    public LineString readLineString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readLineString(filter, hasZ, hasM);
    }

    public LineString readLineString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        LineString lineString = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            lineString = new LineString(hasZ, hasM);
            do {
                Point point;
                if (!GeometryReader.filter(filter, GeometryType.LINESTRING, (Geometry)(point = this.readPoint(hasZ, hasM)))) continue;
                lineString.addPoint(point);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return lineString;
    }

    public Polygon readPolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readPolygon(filter, hasZ, hasM);
    }

    public Polygon readPolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        Polygon polygon = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            polygon = new Polygon(hasZ, hasM);
            do {
                LineString ring;
                if (!GeometryReader.filter(filter, GeometryType.POLYGON, (Geometry)(ring = this.readLineString(filter, hasZ, hasM)))) continue;
                polygon.addRing((Curve)ring);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return polygon;
    }

    public MultiPoint readMultiPoint(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiPoint(filter, hasZ, hasM);
    }

    public MultiPoint readMultiPoint(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiPoint multiPoint = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            multiPoint = new MultiPoint(hasZ, hasM);
            do {
                Point point = null;
                point = GeometryReader.isLeftParenthesisOrEmpty(this.reader) ? this.readPointText(hasZ, hasM) : this.readPoint(hasZ, hasM);
                if (!GeometryReader.filter(filter, GeometryType.MULTIPOINT, (Geometry)point)) continue;
                multiPoint.addPoint(point);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return multiPoint;
    }

    public MultiLineString readMultiLineString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiLineString(filter, hasZ, hasM);
    }

    public MultiLineString readMultiLineString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiLineString multiLineString = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            multiLineString = new MultiLineString(hasZ, hasM);
            do {
                LineString lineString;
                if (!GeometryReader.filter(filter, GeometryType.MULTILINESTRING, (Geometry)(lineString = this.readLineString(filter, hasZ, hasM)))) continue;
                multiLineString.addLineString(lineString);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return multiLineString;
    }

    public MultiPolygon readMultiPolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readMultiPolygon(filter, hasZ, hasM);
    }

    public MultiPolygon readMultiPolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        MultiPolygon multiPolygon = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            multiPolygon = new MultiPolygon(hasZ, hasM);
            do {
                Polygon polygon;
                if (!GeometryReader.filter(filter, GeometryType.MULTIPOLYGON, (Geometry)(polygon = this.readPolygon(filter, hasZ, hasM)))) continue;
                multiPolygon.addPolygon(polygon);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return multiPolygon;
    }

    public GeometryCollection<Geometry> readGeometryCollection(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readGeometryCollection(filter, hasZ, hasM);
    }

    public GeometryCollection<Geometry> readGeometryCollection(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryCollection geometryCollection = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            geometryCollection = new GeometryCollection(hasZ, hasM);
            do {
                Geometry geometry;
                if ((geometry = this.read(filter, GeometryType.GEOMETRYCOLLECTION, Geometry.class)) == null) continue;
                geometryCollection.addGeometry(geometry);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return geometryCollection;
    }

    public GeometryCollection<Curve> readMultiCurve(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryCollection multiCurve = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            multiCurve = new GeometryCollection(hasZ, hasM);
            do {
                LineString curve = null;
                if (GeometryReader.isLeftParenthesisOrEmpty(this.reader)) {
                    curve = this.readLineString(filter, hasZ, hasM);
                    if (!GeometryReader.filter(filter, GeometryType.MULTICURVE, (Geometry)curve)) {
                        curve = null;
                    }
                } else {
                    curve = this.read(filter, GeometryType.MULTICURVE, Curve.class);
                }
                if (curve == null) continue;
                multiCurve.addGeometry((Geometry)curve);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return multiCurve;
    }

    public GeometryCollection<Surface> readMultiSurface(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryCollection multiSurface = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            multiSurface = new GeometryCollection(hasZ, hasM);
            do {
                Polygon surface = null;
                if (GeometryReader.isLeftParenthesisOrEmpty(this.reader)) {
                    surface = this.readPolygon(filter, hasZ, hasM);
                    if (!GeometryReader.filter(filter, GeometryType.MULTISURFACE, (Geometry)surface)) {
                        surface = null;
                    }
                } else {
                    surface = this.read(filter, GeometryType.MULTISURFACE, Surface.class);
                }
                if (surface == null) continue;
                multiSurface.addGeometry((Geometry)surface);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return multiSurface;
    }

    public CircularString readCircularString(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCircularString(filter, hasZ, hasM);
    }

    public CircularString readCircularString(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CircularString circularString = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            circularString = new CircularString(hasZ, hasM);
            do {
                Point point;
                if (!GeometryReader.filter(filter, GeometryType.CIRCULARSTRING, (Geometry)(point = this.readPoint(hasZ, hasM)))) continue;
                circularString.addPoint(point);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return circularString;
    }

    public CompoundCurve readCompoundCurve(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCompoundCurve(filter, hasZ, hasM);
    }

    public CompoundCurve readCompoundCurve(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CompoundCurve compoundCurve = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            compoundCurve = new CompoundCurve(hasZ, hasM);
            do {
                LineString lineString = null;
                if (GeometryReader.isLeftParenthesisOrEmpty(this.reader)) {
                    lineString = this.readLineString(filter, hasZ, hasM);
                    if (!GeometryReader.filter(filter, GeometryType.COMPOUNDCURVE, (Geometry)lineString)) {
                        lineString = null;
                    }
                } else {
                    lineString = this.read(filter, GeometryType.COMPOUNDCURVE, LineString.class);
                }
                if (lineString == null) continue;
                compoundCurve.addLineString(lineString);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return compoundCurve;
    }

    public CurvePolygon<Curve> readCurvePolygon(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readCurvePolygon(filter, hasZ, hasM);
    }

    public CurvePolygon<Curve> readCurvePolygon(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        CurvePolygon curvePolygon = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            curvePolygon = new CurvePolygon(hasZ, hasM);
            do {
                LineString ring = null;
                if (GeometryReader.isLeftParenthesisOrEmpty(this.reader)) {
                    ring = this.readLineString(filter, hasZ, hasM);
                    if (!GeometryReader.filter(filter, GeometryType.CURVEPOLYGON, (Geometry)ring)) {
                        ring = null;
                    }
                } else {
                    ring = this.read(filter, GeometryType.CURVEPOLYGON, Curve.class);
                }
                if (ring == null) continue;
                curvePolygon.addRing((Curve)ring);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return curvePolygon;
    }

    public PolyhedralSurface readPolyhedralSurface(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readPolyhedralSurface(filter, hasZ, hasM);
    }

    public PolyhedralSurface readPolyhedralSurface(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        PolyhedralSurface polyhedralSurface = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            polyhedralSurface = new PolyhedralSurface(hasZ, hasM);
            do {
                Polygon polygon;
                if (!GeometryReader.filter(filter, GeometryType.POLYHEDRALSURFACE, (Geometry)(polygon = this.readPolygon(filter, hasZ, hasM)))) continue;
                polyhedralSurface.addPolygon(polygon);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return polyhedralSurface;
    }

    public TIN readTIN(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readTIN(filter, hasZ, hasM);
    }

    public TIN readTIN(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        TIN tin = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            tin = new TIN(hasZ, hasM);
            do {
                Polygon polygon;
                if (!GeometryReader.filter(filter, GeometryType.TIN, (Geometry)(polygon = this.readPolygon(filter, hasZ, hasM)))) continue;
                tin.addPolygon(polygon);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return tin;
    }

    public Triangle readTriangle(boolean hasZ, boolean hasM) throws IOException {
        GeometryFilter filter = null;
        return this.readTriangle(filter, hasZ, hasM);
    }

    public Triangle readTriangle(GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        Triangle triangle = null;
        if (GeometryReader.leftParenthesisOrEmpty(this.reader)) {
            triangle = new Triangle(hasZ, hasM);
            do {
                LineString ring;
                if (!GeometryReader.filter(filter, GeometryType.TRIANGLE, (Geometry)(ring = this.readLineString(filter, hasZ, hasM)))) continue;
                triangle.addRing((Curve)ring);
            } while (GeometryReader.commaOrRightParenthesis(this.reader));
        }
        return triangle;
    }

    public static Geometry readGeometry(TextReader reader) throws IOException {
        return GeometryReader.readGeometry(reader, null, null);
    }

    public static Geometry readGeometry(TextReader reader, GeometryFilter filter) throws IOException {
        return GeometryReader.readGeometry(reader, filter, null);
    }

    public static <T extends Geometry> T readGeometry(TextReader reader, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(reader, null, expectedType);
    }

    public static <T extends Geometry> T readGeometry(TextReader reader, GeometryFilter filter, Class<T> expectedType) throws IOException {
        return GeometryReader.readGeometry(reader, filter, null, expectedType);
    }

    public static <T extends Geometry> T readGeometry(TextReader reader, GeometryFilter filter, GeometryType containingType, Class<T> expectedType) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.read(filter, containingType, expectedType);
    }

    public static GeometryTypeInfo readGeometryType(TextReader reader) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryType();
    }

    public static Point readPointText(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPointText(hasZ, hasM);
    }

    public static Point readPoint(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPoint(hasZ, hasM);
    }

    public static LineString readLineString(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readLineString(hasZ, hasM);
    }

    public static LineString readLineString(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readLineString(filter, hasZ, hasM);
    }

    public static Polygon readPolygon(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolygon(hasZ, hasM);
    }

    public static Polygon readPolygon(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolygon(filter, hasZ, hasM);
    }

    public static MultiPoint readMultiPoint(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPoint(hasZ, hasM);
    }

    public static MultiPoint readMultiPoint(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPoint(filter, hasZ, hasM);
    }

    public static MultiLineString readMultiLineString(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiLineString(hasZ, hasM);
    }

    public static MultiLineString readMultiLineString(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiLineString(filter, hasZ, hasM);
    }

    public static MultiPolygon readMultiPolygon(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPolygon(hasZ, hasM);
    }

    public static MultiPolygon readMultiPolygon(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiPolygon(filter, hasZ, hasM);
    }

    public static GeometryCollection<Geometry> readGeometryCollection(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryCollection(hasZ, hasM);
    }

    public static GeometryCollection<Geometry> readGeometryCollection(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readGeometryCollection(filter, hasZ, hasM);
    }

    public static GeometryCollection<Curve> readMultiCurve(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiCurve(filter, hasZ, hasM);
    }

    public static GeometryCollection<Surface> readMultiSurface(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readMultiSurface(filter, hasZ, hasM);
    }

    public static CircularString readCircularString(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCircularString(hasZ, hasM);
    }

    public static CircularString readCircularString(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCircularString(filter, hasZ, hasM);
    }

    public static CompoundCurve readCompoundCurve(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCompoundCurve(hasZ, hasM);
    }

    public static CompoundCurve readCompoundCurve(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCompoundCurve(filter, hasZ, hasM);
    }

    public static CurvePolygon<Curve> readCurvePolygon(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCurvePolygon(hasZ, hasM);
    }

    public static CurvePolygon<Curve> readCurvePolygon(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readCurvePolygon(filter, hasZ, hasM);
    }

    public static PolyhedralSurface readPolyhedralSurface(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolyhedralSurface(hasZ, hasM);
    }

    public static PolyhedralSurface readPolyhedralSurface(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readPolyhedralSurface(filter, hasZ, hasM);
    }

    public static TIN readTIN(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTIN(hasZ, hasM);
    }

    public static TIN readTIN(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTIN(filter, hasZ, hasM);
    }

    public static Triangle readTriangle(TextReader reader, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTriangle(hasZ, hasM);
    }

    public static Triangle readTriangle(TextReader reader, GeometryFilter filter, boolean hasZ, boolean hasM) throws IOException {
        GeometryReader geometryReader = new GeometryReader(reader);
        return geometryReader.readTriangle(filter, hasZ, hasM);
    }

    private static boolean leftParenthesisOrEmpty(TextReader reader) throws IOException {
        boolean nonEmpty;
        String token = reader.readToken();
        switch (GeometryReader.toUpperCase(token)) {
            case "EMPTY": {
                nonEmpty = false;
                break;
            }
            case "(": {
                nonEmpty = true;
                break;
            }
            default: {
                throw new SFException("Invalid token, expected 'EMPTY' or '('. found: '" + token + "'");
            }
        }
        return nonEmpty;
    }

    private static boolean commaOrRightParenthesis(TextReader reader) throws IOException {
        boolean comma;
        String token = reader.readToken();
        switch (GeometryReader.toUpperCase(token)) {
            case ",": {
                comma = true;
                break;
            }
            case ")": {
                comma = false;
                break;
            }
            default: {
                throw new SFException("Invalid token, expected ',' or ')'. found: '" + token + "'");
            }
        }
        return comma;
    }

    private static void rightParenthesis(TextReader reader) throws IOException {
        String token = reader.readToken();
        if (!token.equals(")")) {
            throw new SFException("Invalid token, expected ')'. found: '" + token + "'");
        }
    }

    private static boolean isLeftParenthesisOrEmpty(TextReader reader) throws IOException {
        boolean is = false;
        String token = reader.peekToken();
        switch (GeometryReader.toUpperCase(token)) {
            case "EMPTY": 
            case "(": {
                is = true;
                break;
            }
        }
        return is;
    }

    private static boolean isCommaOrRightParenthesis(TextReader reader) throws IOException {
        String token;
        boolean is = false;
        switch (token = reader.peekToken()) {
            case ",": 
            case ")": {
                is = true;
                break;
            }
        }
        return is;
    }

    private static boolean filter(GeometryFilter filter, GeometryType containingType, Geometry geometry) {
        return filter == null || geometry == null || filter.filter(containingType, geometry);
    }

    private static String toUpperCase(String value) {
        return value != null ? value.toUpperCase(Locale.US) : "";
    }
}

