/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.logging.slf4j.internal;

import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.Objects;
import org.slf4j.Logger;

final class WarnLogger
implements FixedLevelLogger {
    private final Logger logger;

    WarnLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public String loggerName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel logLevel() {
        return LogLevel.WARN;
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void log(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void log(String msg, Throwable cause) {
        this.logger.warn(msg, cause);
    }

    @Override
    public void log(String format, Object arg) {
        this.logger.warn(format, arg);
    }

    @Override
    public void log(String format, Object arg1, Object arg2) {
        this.logger.warn(format, arg1, arg2);
    }

    @Override
    public void log(String format, Object ... args) {
        this.logger.warn(format, args);
    }
}

