/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.logging.slf4j.internal;

import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.Objects;
import org.slf4j.Logger;

final class InfoLogger
implements FixedLevelLogger {
    private final Logger logger;

    InfoLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public String loggerName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel logLevel() {
        return LogLevel.INFO;
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void log(String msg, Throwable cause) {
        this.logger.info(msg, cause);
    }

    @Override
    public void log(String format, Object arg) {
        this.logger.info(format, arg);
    }

    @Override
    public void log(String format, Object arg1, Object arg2) {
        this.logger.info(format, arg1, arg2);
    }

    @Override
    public void log(String format, Object ... args) {
        this.logger.info(format, args);
    }
}

