/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.logging.slf4j.internal;

import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.Objects;
import org.slf4j.Logger;

final class ErrorLogger
implements FixedLevelLogger {
    private final Logger logger;

    ErrorLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public String loggerName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel logLevel() {
        return LogLevel.ERROR;
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void log(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void log(String msg, Throwable cause) {
        this.logger.error(msg, cause);
    }

    @Override
    public void log(String format, Object arg) {
        this.logger.error(format, arg);
    }

    @Override
    public void log(String format, Object arg1, Object arg2) {
        this.logger.error(format, arg1, arg2);
    }

    @Override
    public void log(String format, Object ... args) {
        this.logger.error(format, args);
    }
}

