/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ripe.ipresource.IpResourceRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.Validate;

public abstract class IpResource
implements Serializable,
Comparable<IpResource> {
    private static final long serialVersionUID = 1L;

    public abstract IpResourceType getType();

    @Override
    public int compareTo(IpResource that) {
        int rc = this.getType().compareTo(that.getType());
        if (rc != 0) {
            return rc;
        }
        return this.doCompareTo(that);
    }

    public boolean contains(IpResource other) {
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getStart().compareTo(other.getStart()) <= 0 && this.getEnd().compareTo(other.getEnd()) >= 0;
    }

    public boolean overlaps(IpResource other) {
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getStart().compareTo(other.getEnd()) <= 0 && this.getEnd().compareTo(other.getStart()) >= 0;
    }

    public boolean adjacent(IpResource other) {
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.overlaps(other)) {
            return false;
        }
        return this.getEnd().adjacent(other.getStart()) || this.getStart().adjacent(other.getEnd());
    }

    public boolean isMergeable(IpResource other) {
        return this.overlaps(other) || this.adjacent(other);
    }

    public IpResource merge(IpResource other) {
        Validate.isTrue((boolean)this.isMergeable(other));
        return this.getStart().min(other.getStart()).upTo(this.getEnd().max(other.getEnd()));
    }

    public boolean isUnique() {
        return this.getStart().equals(this.getEnd());
    }

    public abstract UniqueIpResource unique();

    public abstract UniqueIpResource getStart();

    public abstract UniqueIpResource getEnd();

    public boolean isValidNetmask() {
        return false;
    }

    protected abstract int doCompareTo(IpResource var1);

    protected abstract int doHashCode();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IpResource)) {
            return false;
        }
        return this.compareTo((IpResource)other) == 0;
    }

    public final int hashCode() {
        return this.doHashCode();
    }

    public List<IpResourceRange> subtract(IpResource value) {
        UniqueIpResource end;
        UniqueIpResource valueEnd;
        UniqueIpResource valueStart;
        if (!this.overlaps(value)) {
            return Collections.singletonList(this.getStart().upTo(this.getEnd()));
        }
        if (value.contains(this)) {
            return Collections.emptyList();
        }
        ArrayList<IpResourceRange> result = new ArrayList<IpResourceRange>(2);
        UniqueIpResource start = this.getStart();
        if (start.compareTo(valueStart = value.getStart()) < 0) {
            result.add(start.upTo(valueStart.predecessor()));
        }
        if ((valueEnd = value.getEnd()).compareTo(end = this.getEnd()) < 0) {
            result.add(valueEnd.successor().upTo(end));
        }
        return result;
    }

    public IpResource intersect(IpResource value) {
        UniqueIpResource end;
        if (this.getType() != value.getType()) {
            return null;
        }
        UniqueIpResource start = this.getStart().max(value.getStart());
        if (start.compareTo(end = this.getEnd().min(value.getEnd())) > 0) {
            return null;
        }
        return start.upTo(end);
    }

    public static IpResource parse(String s) {
        try {
            return IpResourceRange.parse(s);
        }
        catch (IllegalArgumentException ex) {
            return UniqueIpResource.parse(s);
        }
    }
}

