/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.schema.constraints;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.schema.columns.DataColumns;
import mil.nga.geopackage.extension.schema.columns.DataColumnsDao;
import mil.nga.geopackage.extension.schema.constraints.DataColumnConstraintType;
import mil.nga.geopackage.extension.schema.constraints.DataColumnConstraintsDao;

@DatabaseTable(tableName="gpkg_data_column_constraints", daoClass=DataColumnConstraintsDao.class)
public class DataColumnConstraints {
    public static final String TABLE_NAME = "gpkg_data_column_constraints";
    public static final String COLUMN_CONSTRAINT_NAME = "constraint_name";
    public static final String COLUMN_CONSTRAINT_TYPE = "constraint_type";
    public static final String COLUMN_VALUE = "value";
    public static final String COLUMN_MIN = "min";
    public static final String COLUMN_MIN_IS_INCLUSIVE = "min_is_inclusive";
    public static final String COLUMN_MAX = "max";
    public static final String COLUMN_MAX_IS_INCLUSIVE = "max_is_inclusive";
    public static final String COLUMN_DESCRIPTION = "description";
    @DatabaseField(columnName="constraint_name", canBeNull=false, uniqueCombo=true)
    private String constraintName;
    @DatabaseField(columnName="constraint_type", canBeNull=false, uniqueCombo=true)
    private String constraintType;
    @DatabaseField(columnName="value", uniqueCombo=true)
    private String value;
    @DatabaseField(columnName="min")
    private BigDecimal min;
    @DatabaseField(columnName="min_is_inclusive")
    private Boolean minIsInclusive;
    @DatabaseField(columnName="max")
    private BigDecimal max;
    @DatabaseField(columnName="max_is_inclusive")
    private Boolean maxIsInclusive;
    @DatabaseField(columnName="description")
    private String description;

    public DataColumnConstraints() {
    }

    public DataColumnConstraints(DataColumnConstraints dataColumnConstraints) {
        this.constraintName = dataColumnConstraints.constraintName;
        this.constraintType = dataColumnConstraints.constraintType;
        this.value = dataColumnConstraints.value;
        this.min = dataColumnConstraints.min;
        this.minIsInclusive = dataColumnConstraints.minIsInclusive;
        this.max = dataColumnConstraints.max;
        this.maxIsInclusive = dataColumnConstraints.maxIsInclusive;
        this.description = dataColumnConstraints.description;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public DataColumnConstraintType getConstraintType() {
        return DataColumnConstraintType.fromValue(this.constraintType);
    }

    public void setConstraintType(String constraintType) {
        DataColumnConstraintType type = DataColumnConstraintType.fromValue(constraintType);
        this.setConstraintType(type);
    }

    public void setConstraintType(DataColumnConstraintType constraintType) {
        this.constraintType = constraintType.getValue();
        switch (constraintType) {
            case RANGE: {
                this.setValue(null);
                break;
            }
            case ENUM: 
            case GLOB: {
                this.setMin(null);
                this.setMax(null);
                this.setMinIsInclusive(null);
                this.setMaxIsInclusive(null);
                break;
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (this.constraintType != null && value != null && this.getConstraintType().equals((Object)DataColumnConstraintType.RANGE)) {
            throw new GeoPackageException("The value must be null for " + DataColumnConstraintType.RANGE + " constraints");
        }
        this.value = value;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.validateRangeValue(COLUMN_MIN, min);
        this.min = min;
    }

    public Boolean getMinIsInclusive() {
        return this.minIsInclusive;
    }

    public void setMinIsInclusive(Boolean minIsInclusive) {
        this.validateRangeValue(COLUMN_MIN_IS_INCLUSIVE, minIsInclusive);
        this.minIsInclusive = minIsInclusive;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.validateRangeValue(COLUMN_MAX, max);
        this.max = max;
    }

    public Boolean getMaxIsInclusive() {
        return this.maxIsInclusive;
    }

    public void setMaxIsInclusive(Boolean maxIsInclusive) {
        this.validateRangeValue(COLUMN_MAX_IS_INCLUSIVE, maxIsInclusive);
        this.maxIsInclusive = maxIsInclusive;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<DataColumns> getColumns(DataColumnsDao dao) throws SQLException {
        List<DataColumns> columns = null;
        if (this.constraintName != null) {
            columns = dao.queryByConstraintName(this.constraintName);
        }
        return columns;
    }

    private void validateRangeValue(String column, Object value) {
        if (this.constraintType != null && value != null && !this.getConstraintType().equals((Object)DataColumnConstraintType.RANGE)) {
            throw new GeoPackageException("The " + column + " must be null for " + DataColumnConstraintType.ENUM + " and " + DataColumnConstraintType.GLOB + " constraints");
        }
    }
}

