/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.im.portrayal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.im.portrayal.PortrayalTableCreator;
import mil.nga.geopackage.extension.im.portrayal.StylesDao;
import mil.nga.geopackage.extension.im.portrayal.StylesheetsDao;
import mil.nga.geopackage.extension.im.portrayal.SymbolContentDao;
import mil.nga.geopackage.extension.im.portrayal.SymbolImagesDao;
import mil.nga.geopackage.extension.im.portrayal.SymbolsDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class PortrayalExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "im";
    public static final String EXTENSION_NAME_NO_AUTHOR = "portrayal";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("im", "portrayal");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "portrayal");
    private final StylesheetsDao stylesheetsDao = this.getStylesheetsDao();
    private final StylesDao stylesDao = this.getStylesDao();
    private final SymbolContentDao symbolContentDao = this.getSymbolContentDao();
    private final SymbolImagesDao symbolImagesDao = this.getSymbolImagesDao();
    private final SymbolsDao symbolsDao = this.getSymbolsDao();

    public PortrayalExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, "gpkgext_styles", null) && this.geoPackage.isTable("gpkgext_styles") && this.geoPackage.isTable("gpkgext_stylesheets") && this.geoPackage.isTable("gpkgext_symbols") && this.geoPackage.isTable("gpkgext_symbol_content") && this.geoPackage.isTable("gpkgext_symbol_images");
    }

    public List<Extensions> getOrCreate() {
        this.createPortrayalTables();
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_styles", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_stylesheets", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_symbols", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_symbol_images", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_symbol_content", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        return extensions;
    }

    public void removeExtension() {
        try {
            if (this.stylesDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_styles");
            }
            if (this.stylesheetsDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_stylesheets");
            }
            if (this.symbolsDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_symbols");
            }
            if (this.symbolImagesDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_symbol_images");
            }
            if (this.symbolContentDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_symbol_content");
            }
            this.extensionsDao.deleteByExtension(EXTENSION_NAME);
        }
        catch (SQLException var4) {
            throw new GeoPackageException("Failed to delete Portrayal extension and table. GeoPackage: " + this.geoPackage.getName(), var4);
        }
    }

    public StylesDao getStylesDao() {
        return PortrayalExtension.getStylesDao(this.geoPackage);
    }

    public static StylesDao getStylesDao(GeoPackageCore geoPackage) {
        return StylesDao.create(geoPackage);
    }

    public static StylesDao getStylesDao(GeoPackageCoreConnection db) {
        return StylesDao.create(db);
    }

    public StylesheetsDao getStylesheetsDao() {
        return PortrayalExtension.getStylesheetsDao(this.geoPackage);
    }

    public static StylesheetsDao getStylesheetsDao(GeoPackageCore geoPackage) {
        return StylesheetsDao.create(geoPackage);
    }

    public static StylesheetsDao getStylesheetsDao(GeoPackageCoreConnection db) {
        return StylesheetsDao.create(db);
    }

    public SymbolContentDao getSymbolContentDao() {
        return PortrayalExtension.getSymbolContentDao(this.geoPackage);
    }

    public static SymbolContentDao getSymbolContentDao(GeoPackageCore geoPackage) {
        return SymbolContentDao.create(geoPackage);
    }

    public static SymbolContentDao getSymbolContentDao(GeoPackageCoreConnection db) {
        return SymbolContentDao.create(db);
    }

    public SymbolImagesDao getSymbolImagesDao() {
        return PortrayalExtension.getSymbolImagesDao(this.geoPackage);
    }

    public static SymbolImagesDao getSymbolImagesDao(GeoPackageCore geoPackage) {
        return SymbolImagesDao.create(geoPackage);
    }

    public static SymbolImagesDao getSymbolImagesDao(GeoPackageCoreConnection db) {
        return SymbolImagesDao.create(db);
    }

    public SymbolsDao getSymbolsDao() {
        return PortrayalExtension.getSymbolsDao(this.geoPackage);
    }

    public static SymbolsDao getSymbolsDao(GeoPackageCore geoPackage) {
        return SymbolsDao.create(geoPackage);
    }

    public static SymbolsDao getSymbolsDao(GeoPackageCoreConnection db) {
        return SymbolsDao.create(db);
    }

    public boolean createPortrayalTables() {
        this.verifyWritable();
        boolean created = false;
        PortrayalTableCreator tableCreator = new PortrayalTableCreator(this.geoPackage);
        try {
            if (!this.stylesDao.isTableExists()) {
                created = tableCreator.createStyles() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_styles table exists and create it", e);
        }
        try {
            if (!this.stylesheetsDao.isTableExists()) {
                created = tableCreator.createStylesheets() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_stylesheets table exists and create it", e);
        }
        try {
            if (!this.symbolsDao.isTableExists()) {
                created = tableCreator.createSymbols() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_stylesheets table exists and create it", e);
        }
        try {
            if (!this.symbolContentDao.isTableExists()) {
                created = tableCreator.createSymbolContent() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_symbol_content table exists and create it", e);
        }
        try {
            if (!this.symbolImagesDao.isTableExists()) {
                created = tableCreator.createSymbolImages() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_symbol_images table exists and create it", e);
        }
        return created;
    }
}

