/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.db.table.ConstraintParser;
import mil.nga.geopackage.db.table.TableConstraints;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.ExtensionManagement;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.coverage.CoverageDataCore;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedTileDao;
import mil.nga.geopackage.extension.ecere.EcereExtensions;
import mil.nga.geopackage.extension.im.ImageMattersExtensions;
import mil.nga.geopackage.extension.metadata.MetadataExtension;
import mil.nga.geopackage.extension.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.extension.nga.NGAExtensions;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.ExtendedRelationsDao;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.rtree.RTreeIndexCoreExtension;
import mil.nga.geopackage.extension.schema.SchemaExtension;
import mil.nga.geopackage.extension.schema.columns.DataColumnsDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public class ExtensionManager
extends ExtensionManagement {
    private static final Logger logger = Logger.getLogger(ExtensionManager.class.getName());
    private final List<ExtensionManagement> communityExtensions = new ArrayList<ExtensionManagement>();

    public ExtensionManager(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.communityExtensions.add(new NGAExtensions(geoPackage));
        this.communityExtensions.add(new ImageMattersExtensions(geoPackage));
        this.communityExtensions.add(new EcereExtensions(geoPackage));
    }

    @Override
    public String getAuthor() {
        return "gpkg";
    }

    @Override
    public void deleteTableExtensions(String table) {
        for (ExtensionManagement extensions : this.communityExtensions) {
            extensions.deleteTableExtensions(table);
        }
        this.deleteRTreeSpatialIndex(table);
        this.deleteRelatedTables(table);
        this.deleteGriddedCoverage(table);
        this.deleteSchema(table);
        this.deleteMetadata(table);
        this.delete(table);
    }

    @Override
    public void deleteExtensions() {
        for (ExtensionManagement extensions : this.communityExtensions) {
            extensions.deleteExtensions();
        }
        this.deleteRTreeSpatialIndexExtension();
        this.deleteRelatedTablesExtension();
        this.deleteGriddedCoverageExtension();
        this.deleteSchemaExtension();
        this.deleteMetadataExtension();
        this.deleteCrsWktExtension();
        this.delete();
    }

    @Override
    public void copyTableExtensions(String table, String newTable) {
        try {
            this.copyRTreeSpatialIndex(table, newTable);
            this.copyRelatedTables(table, newTable);
            this.copyGriddedCoverage(table, newTable);
            this.copySchema(table, newTable);
            this.copyMetadata(table, newTable);
            for (ExtensionManagement extensions : this.communityExtensions) {
                try {
                    extensions.copyTableExtensions(table, newTable);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to copy '" + extensions.getAuthor() + "' extensions for table: " + newTable + ", copied from table: " + table, e);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to copy extensions for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private void delete(String table) {
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table extensions. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    private void delete() {
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                this.geoPackage.dropTable(extensionsDao.getTableName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete all extensions. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public void deleteRTreeSpatialIndex(String table) {
        RTreeIndexCoreExtension rTreeIndexExtension = this.getRTreeIndexExtension();
        if (rTreeIndexExtension.has(table)) {
            rTreeIndexExtension.delete(table);
        }
    }

    public void deleteRTreeSpatialIndexExtension() {
        RTreeIndexCoreExtension rTreeIndexExtension = this.getRTreeIndexExtension();
        if (rTreeIndexExtension.has()) {
            rTreeIndexExtension.deleteAll();
        }
    }

    public void copyRTreeSpatialIndex(String table, String newTable) {
        try {
            TableInfo tableInfo;
            GeometryColumnsDao geometryColumnsDao;
            GeometryColumns geometryColumns;
            RTreeIndexCoreExtension rTreeIndexExtension = this.getRTreeIndexExtension();
            if (rTreeIndexExtension.has(table) && (geometryColumns = (geometryColumnsDao = this.geoPackage.getGeometryColumnsDao()).queryForTableName(newTable)) != null && (tableInfo = TableInfo.info(this.geoPackage.getDatabase(), newTable)) != null) {
                String pk = tableInfo.getPrimaryKey().getName();
                rTreeIndexExtension.create(newTable, geometryColumns.getColumnName(), pk);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create RTree for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private RTreeIndexCoreExtension getRTreeIndexExtension() {
        return new RTreeIndexCoreExtension(this.geoPackage){

            @Override
            public void createMinYFunction() {
            }

            @Override
            public void createMinXFunction() {
            }

            @Override
            public void createMaxYFunction() {
            }

            @Override
            public void createMaxXFunction() {
            }

            @Override
            public void createIsEmptyFunction() {
            }
        };
    }

    public void deleteRelatedTables(String table) {
        RelatedTablesCoreExtension relatedTablesExtension = this.getRelatedTableExtension();
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeRelationships(table);
        }
    }

    public void deleteRelatedTablesExtension() {
        RelatedTablesCoreExtension relatedTablesExtension = this.getRelatedTableExtension();
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeExtension();
        }
    }

    public void copyRelatedTables(String table, String newTable) {
        try {
            RelatedTablesCoreExtension relatedTablesExtension = this.getRelatedTableExtension();
            if (relatedTablesExtension.has()) {
                ExtendedRelationsDao extendedRelationsDao = relatedTablesExtension.getExtendedRelationsDao();
                ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
                List<ExtendedRelation> extendedRelations = extendedRelationsDao.getBaseTableRelations(table);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    String mappingTableName = extendedRelation.getMappingTableName();
                    List<Extensions> extensions = extensionsDao.queryByExtension(RelatedTablesCoreExtension.EXTENSION_NAME, mappingTableName);
                    if (extensions.isEmpty()) continue;
                    String newMappingTableName = CoreSQLUtils.createName(this.geoPackage.getDatabase(), mappingTableName, table, newTable);
                    UserCustomTable userTable = UserCustomTableReader.readTable(this.geoPackage.getDatabase(), mappingTableName);
                    AlterTable.copyTable(this.geoPackage.getDatabase(), userTable, newMappingTableName);
                    Extensions extension = extensions.get(0);
                    extension.setTableName(newMappingTableName);
                    extensionsDao.create(extension);
                    TableMapping extendedRelationTableMapping = new TableMapping(this.geoPackage.getDatabase(), "gpkgext_relations");
                    extendedRelationTableMapping.removeColumn("id");
                    MappedColumn baseTableNameColumn = extendedRelationTableMapping.getColumn("base_table_name");
                    baseTableNameColumn.setConstantValue(newTable);
                    baseTableNameColumn.setWhereValue(table);
                    MappedColumn mappingTableNameColumn = extendedRelationTableMapping.getColumn("mapping_table_name");
                    mappingTableNameColumn.setConstantValue(newMappingTableName);
                    mappingTableNameColumn.setWhereValue(mappingTableName);
                    CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), extendedRelationTableMapping);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Related Tables for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private RelatedTablesCoreExtension getRelatedTableExtension() {
        return new RelatedTablesCoreExtension(this.geoPackage){};
    }

    public void deleteGriddedCoverage(String table) {
        if (this.geoPackage.isTableType(table, "2d-gridded-coverage")) {
            GriddedTileDao griddedTileDao = CoverageDataCore.getGriddedTileDao(this.geoPackage);
            GriddedCoverageDao griddedCoverageDao = CoverageDataCore.getGriddedCoverageDao(this.geoPackage);
            ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
            try {
                if (griddedTileDao.isTableExists()) {
                    griddedTileDao.delete(table);
                }
                if (griddedCoverageDao.isTableExists()) {
                    griddedCoverageDao.delete(table);
                }
                if (extensionsDao.isTableExists()) {
                    extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME, table);
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
            }
        }
    }

    public void deleteGriddedCoverageExtension() {
        List<String> coverageTables = this.geoPackage.getTables("2d-gridded-coverage");
        for (String table : coverageTables) {
            this.geoPackage.deleteTable(table);
        }
        GriddedTileDao griddedTileDao = CoverageDataCore.getGriddedTileDao(this.geoPackage);
        GriddedCoverageDao griddedCoverageDao = CoverageDataCore.getGriddedCoverageDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (griddedTileDao.isTableExists()) {
                this.geoPackage.dropTable(griddedTileDao.getTableName());
            }
            if (griddedCoverageDao.isTableExists()) {
                this.geoPackage.dropTable(griddedCoverageDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Gridded Coverage extension and tables. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public void copyGriddedCoverage(String table, String newTable) {
        try {
            List<Extensions> extensions;
            ExtensionsDao extensionsDao;
            if (this.geoPackage.isTableType(table, "2d-gridded-coverage") && (extensionsDao = this.geoPackage.getExtensionsDao()).isTableExists() && !(extensions = extensionsDao.queryByExtension(CoverageDataCore.EXTENSION_NAME, table)).isEmpty()) {
                GriddedTileDao griddedTileDao;
                Extensions extension = extensions.get(0);
                extension.setTableName(newTable);
                extensionsDao.create(extension);
                GriddedCoverageDao griddedCoverageDao = CoverageDataCore.getGriddedCoverageDao(this.geoPackage);
                if (griddedCoverageDao.isTableExists()) {
                    CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "gpkg_2d_gridded_coverage_ancillary", "tile_matrix_set_name", newTable, table, "id");
                }
                if ((griddedTileDao = CoverageDataCore.getGriddedTileDao(this.geoPackage)).isTableExists()) {
                    CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "gpkg_2d_gridded_tile_ancillary", "tpudt_name", newTable, table, "id");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Gridded Coverage for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteSchema(String table) {
        DataColumnsDao dataColumnsDao = SchemaExtension.getDataColumnsDao(this.geoPackage);
        try {
            if (dataColumnsDao.isTableExists()) {
                dataColumnsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Schema extension. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public void deleteSchemaExtension() {
        SchemaExtension schemaExtension = new SchemaExtension(this.geoPackage);
        if (schemaExtension.has()) {
            schemaExtension.removeExtension();
        }
    }

    public void copySchema(String table, String newTable) {
        try {
            if (this.geoPackage.isTableOrView("gpkg_data_columns")) {
                UserCustomTable dataColumnsTable = UserCustomTableReader.readTable(this.geoPackage.getDatabase(), "gpkg_data_columns");
                UserCustomColumn nameColumn = (UserCustomColumn)dataColumnsTable.getColumn("name");
                if (nameColumn.hasConstraints()) {
                    nameColumn.clearConstraints();
                    if (dataColumnsTable.hasConstraints()) {
                        dataColumnsTable.clearConstraints();
                        String constraintSql = GeoPackageTableCreator.readScript("schema", "data_columns").get(0);
                        TableConstraints constraints = ConstraintParser.getConstraints(constraintSql);
                        dataColumnsTable.addConstraints(constraints.getTableConstraints());
                    }
                    AlterTable.alterColumn(this.geoPackage.getDatabase(), dataColumnsTable, nameColumn);
                }
                CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "gpkg_data_columns", "table_name", newTable, table);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Schema for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteMetadata(String table) {
        MetadataReferenceDao metadataReferenceDao = MetadataExtension.getMetadataReferenceDao(this.geoPackage);
        try {
            if (metadataReferenceDao.isTableExists()) {
                metadataReferenceDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Metadata extension. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public void deleteMetadataExtension() {
        MetadataExtension metadataExtension = new MetadataExtension(this.geoPackage);
        if (metadataExtension.has()) {
            metadataExtension.removeExtension();
        }
    }

    public void copyMetadata(String table, String newTable) {
        try {
            if (this.geoPackage.isTableOrView("gpkg_metadata_reference")) {
                CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "gpkg_metadata_reference", "table_name", newTable, table);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Metadata for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteCrsWktExtension() {
        CrsWktExtension crsWktExtension = new CrsWktExtension(this.geoPackage);
        if (crsWktExtension.has()) {
            crsWktExtension.removeExtension();
        }
    }
}

