/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.user.UserColumn;

public class MappedColumn {
    private String toColumn;
    private String fromColumn;
    private Object defaultValue;
    private GeoPackageDataType dataType;
    private Object constantValue;
    private Object whereValue;
    private String whereOperator;

    public MappedColumn(String toColumn) {
        this.toColumn = toColumn;
    }

    public MappedColumn(String toColumn, String fromColumn) {
        this(toColumn);
        this.fromColumn = fromColumn;
    }

    public MappedColumn(String toColumn, String fromColumn, Object defaultValue, GeoPackageDataType dataType) {
        this(toColumn, fromColumn);
        this.defaultValue = defaultValue;
        this.dataType = dataType;
    }

    public MappedColumn(String toColumn, Object defaultValue, GeoPackageDataType dataType) {
        this(toColumn, null, defaultValue, dataType);
    }

    public MappedColumn(UserColumn column) {
        this(column.getName(), column.getDefaultValue(), column.getDataType());
    }

    public MappedColumn(TableColumn column) {
        this(column.getName(), column.getDefaultValue(), column.getDataType());
    }

    public String getToColumn() {
        return this.toColumn;
    }

    public void setToColumn(String toColumn) {
        this.toColumn = toColumn;
    }

    public boolean hasNewName() {
        return this.fromColumn != null && !this.fromColumn.equals(this.toColumn);
    }

    public String getFromColumn() {
        String column = this.fromColumn;
        if (column == null) {
            column = this.toColumn;
        }
        return column;
    }

    public void setFromColumn(String fromColumn) {
        this.fromColumn = fromColumn;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueAsString() {
        return CoreSQLUtils.columnDefaultValue(this.defaultValue, this.dataType);
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public GeoPackageDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(GeoPackageDataType dataType) {
        this.dataType = dataType;
    }

    public boolean hasConstantValue() {
        return this.constantValue != null;
    }

    public Object getConstantValue() {
        return this.constantValue;
    }

    public String getConstantValueAsString() {
        return CoreSQLUtils.columnDefaultValue(this.constantValue, this.dataType);
    }

    public void setConstantValue(Object constantValue) {
        this.constantValue = constantValue;
    }

    public boolean hasWhereValue() {
        return this.whereValue != null;
    }

    public Object getWhereValue() {
        return this.whereValue;
    }

    public String getWhereValueAsString() {
        return CoreSQLUtils.columnDefaultValue(this.whereValue, this.dataType);
    }

    public void setWhereValue(Object whereValue) {
        this.whereValue = whereValue;
    }

    public void setWhereValue(Object whereValue, String whereOperator) {
        this.whereValue = whereValue;
        this.setWhereOperator(whereOperator);
    }

    public String getWhereOperator() {
        return this.whereOperator != null ? this.whereOperator : "=";
    }

    public void setWhereOperator(String whereOperator) {
        this.whereOperator = whereOperator;
    }
}

