/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum GeoPackageDataType {
    BOOLEAN(Boolean.class),
    TINYINT(Byte.class),
    SMALLINT(Short.class),
    MEDIUMINT(Integer.class),
    INT(Long.class),
    INTEGER(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class),
    REAL(Double.class),
    TEXT(String.class),
    BLOB(byte[].class),
    DATE(String.class),
    DATETIME(String.class);

    private static final Map<String, GeoPackageDataType> types;
    private final Class<?> classType;

    private GeoPackageDataType(Class<?> classType) {
        this.classType = classType;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public static GeoPackageDataType fromName(String name) {
        return GeoPackageDataType.valueOf(name.toUpperCase(Locale.US));
    }

    public static GeoPackageDataType findName(String name) {
        return types.get(name.toUpperCase(Locale.US));
    }

    static {
        types = new HashMap<String, GeoPackageDataType>();
        for (GeoPackageDataType type : GeoPackageDataType.values()) {
            types.put(type.name(), type);
        }
    }
}

