/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@ApiModel(description="The spatial extend of the resources in the collection.")
public class ExtentSpatial {
    @Valid
    private List<List<Double>> bbox = new ArrayList<List<Double>>();
    @Valid
    private CrsEnum crs = CrsEnum.HTTP_WWW_OPENGIS_NET_DEF_CRS_OGC_1_3_CRS84;

    public ExtentSpatial bbox(List<List<Double>> bbox) {
        this.bbox = bbox;
        return this;
    }

    @ApiModelProperty(value="One or more bounding boxes or cubes which describe the spatial extent of the collection. If multiple areas are provided, the union of the bounding boxes describes the spatial extent.")
    @JsonProperty(value="bbox")
    @Size(min=1)
    public @Size(min=1) List<List<Double>> getBbox() {
        return this.bbox;
    }

    public void setBbox(List<List<Double>> bbox) {
        this.bbox = bbox;
    }

    public ExtentSpatial crs(CrsEnum crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="Coordinate reference system of the coordinates in the spatial extent (property `spatial`).")
    @JsonProperty(value="crs")
    public CrsEnum getCrs() {
        return this.crs;
    }

    public void setCrs(CrsEnum crs) {
        this.crs = crs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentSpatial extentSpatial = (ExtentSpatial)o;
        return Objects.equals(this.bbox, extentSpatial.bbox) && Objects.equals((Object)this.crs, (Object)extentSpatial.crs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bbox, this.crs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentSpatial {\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString((Object)this.crs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CrsEnum {
        HTTP_WWW_OPENGIS_NET_DEF_CRS_OGC_1_3_CRS84(String.valueOf("http://www.opengis.net/def/crs/OGC/1.3/CRS84"));

        private String value;

        private CrsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CrsEnum fromValue(String value) {
            for (CrsEnum b : CrsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

