/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.model.MbStyle;
import org.apache.baremaps.model.StyleSet;

@Path(value="/styles")
@Api(description="the styles API")
public interface StylesApi {
    @POST
    @Consumes(value={"application/vnd.mapbox.style+json"})
    @ApiOperation(value="adds a new style", notes="Adds a style to the style repository.  In case, a new style is created, the following rules apply.  If the style submitted in the request body includes an identifier (this depends on the style encoding), that identifier will be used. If a style with that identifier already exists, an error is returned.  If no identifier can be determined from the submitted style, the server will assign a new identifier to the style.  The URI of the new style is returned in the header `Location`.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=201, message="style created", response=Void.class), @ApiResponse(code=409, message="a style with that id already exists", response=Void.class)})
    public Response addStyle(@Valid MbStyle var1);

    @DELETE
    @Path(value="/{styleId}")
    @ApiOperation(value="delete a style", notes="Delete an existing style with the id `styleId`. If no such style exists, an error is returned.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=204, message="style deleted", response=Void.class), @ApiResponse(code=404, message="style not found", response=Void.class)})
    public Response deleteStyle(@PathParam(value="styleId") @ApiParam(value="Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID var1);

    @GET
    @Path(value="/{styleId}")
    @Produces(value={"application/vnd.mapbox.style+json"})
    @ApiOperation(value="fetch a style by id", notes="Fetches the style with identifier `styleId`. The set of available styles can be retrieved at `/styles`.  Not all styles are available in all style encodings.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=200, message="The style", response=MbStyle.class), @ApiResponse(code=404, message="style not found", response=Void.class)})
    public Response getStyle(@PathParam(value="styleId") @ApiParam(value="Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID var1);

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="information about the available styles", notes="This operation fetches the set of styles available. For each style the id, a title, links to the stylesheet of the style in each supported encoding, and the link to the metadata is provided.  For a small number of the styles the currently simple approach is sufficient, but in general the operation should support paging (using a parameter `limit` and links to the `next` page in responses).", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=200, message="the set of available styles", response=StyleSet.class), @ApiResponse(code=406, message="The media types accepted by the client are not supported for this resource", response=Void.class)})
    public Response getStyleSet();

    @PUT
    @Path(value="/{styleId}")
    @Consumes(value={"application/vnd.mapbox.style+json"})
    @ApiOperation(value="replace a style or add a new style", notes="Replace an existing style with the id `styleId`. If no such style exists, a new style with that id is added.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=204, message="style updated or created successfully", response=Void.class)})
    public Response updateStyle(@PathParam(value="styleId") @ApiParam(value="Local identifier of a style. \\ A list of all available styles can be found under the /styles path.") UUID var1, @Valid MbStyle var2);
}

