/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.internal.AutoClosableUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public abstract class AbstractCloseableIteratorAsInputStream<T>
extends InputStream {
    private final CloseableIterator<T> iterator;

    protected AbstractCloseableIteratorAsInputStream(CloseableIterator<T> source) {
        this.iterator = Objects.requireNonNull(source);
    }

    protected abstract int leftOverReadableBytes();

    protected abstract void leftOverReadBytes(byte[] var1, int var2, int var3);

    protected abstract boolean hasLeftOver();

    protected abstract void leftOverCheckReset();

    protected abstract void leftOverReset();

    protected abstract void nextLeftOver(CloseableIterator<T> var1);

    protected abstract byte leftOverReadSingleByte();

    protected abstract boolean isClosed();

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        this.checkAlreadyClosed();
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Unexpected offset " + off + " (expected > 0) or length " + len + " (expected >= 0 and should fit in the destination array). Destination array length " + b.length);
        }
        int initialLen = len;
        while (true) {
            if (this.hasLeftOver()) {
                int toRead = Math.min(len, this.leftOverReadableBytes());
                this.leftOverReadBytes(b, off, toRead);
                if (toRead != len) {
                    this.leftOverReset();
                    off += toRead;
                    len -= toRead;
                } else {
                    this.leftOverCheckReset();
                    return initialLen - (len - toRead);
                }
            }
            if (len == 0) {
                return initialLen;
            }
            if (!this.iterator.hasNext()) {
                int bytesRead = initialLen - len;
                return bytesRead == 0 ? -1 : bytesRead;
            }
            this.nextLeftOver(this.iterator);
        }
    }

    @Override
    public final int available() {
        return this.hasLeftOver() ? this.leftOverReadableBytes() : 0;
    }

    @Override
    public void close() throws IOException {
        AutoClosableUtils.closeAndReThrowIoException(this.iterator);
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final int read() throws IOException {
        this.checkAlreadyClosed();
        if (this.hasLeftOver()) {
            return this.leftOverReadSingleByte() & 0xFF;
        }
        while (this.iterator.hasNext()) {
            this.nextLeftOver(this.iterator);
            if (!this.hasLeftOver()) continue;
            if (this.leftOverReadableBytes() != 0) {
                return this.leftOverReadSingleByte() & 0xFF;
            }
            this.leftOverReset();
        }
        return -1;
    }

    private void checkAlreadyClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream is already closed.");
        }
    }
}

