/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpSerializerDeserializer;
import io.servicetalk.http.api.DefaultHttpStreamingSerializer;
import io.servicetalk.http.api.DefaultHttpStreamingSerializerDeserializer;
import io.servicetalk.http.api.FormUrlEncodedSerializer;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSerializerDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.HttpStreamingSerializerDeserializer;
import io.servicetalk.http.api.NonFramedBytesStreamingSerializer;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.serializer.utils.FixedLengthStreamingSerializer;
import io.servicetalk.serializer.utils.StringSerializer;
import io.servicetalk.serializer.utils.VarIntLengthStreamingSerializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public final class HttpSerializers {
    private static final String APPLICATION_TEXT_FIXED_STR = "application/text-fix-int";
    private static final CharSequence APPLICATION_TEXT_FIXED = CharSequences.newAsciiString((CharSequence)"application/text-fix-int");
    private static final CharSequence APPLICATION_TEXT_FIXED_UTF_8 = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_FIXED + "; charset=UTF-8"));
    private static final CharSequence APPLICATION_TEXT_FIXED_US_ASCII = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_FIXED + "; charset=US-ASCII"));
    private static final String APPLICATION_TEXT_VARINT_STR = "application/text-var-int";
    private static final CharSequence APPLICATION_TEXT_VARINT = CharSequences.newAsciiString((CharSequence)"application/text-var-int");
    private static final CharSequence APPLICATION_TEXT_VAR_INT_UTF_8 = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_VARINT + "; charset=UTF-8"));
    private static final CharSequence APPLICATION_TEXT_VAR_INT_US_ASCII = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_VARINT + "; charset=US-ASCII"));
    private static final HttpSerializerDeserializer<Map<String, List<String>>> FORM_ENCODED_UTF_8 = new DefaultHttpSerializerDeserializer<Map<String, List<String>>>(new FormUrlEncodedSerializer(StandardCharsets.UTF_8), headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED_UTF_8).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, StandardCharsets.UTF_8));
    private static final HttpSerializerDeserializer<String> TEXT_UTF_8 = new DefaultHttpSerializerDeserializer<String>(StringSerializer.stringSerializer((Charset)StandardCharsets.UTF_8), headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN_UTF_8).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.TEXT_PLAIN), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, StandardCharsets.UTF_8));
    private static final HttpSerializerDeserializer<String> TEXT_ASCII = new DefaultHttpSerializerDeserializer<String>(StringSerializer.stringSerializer((Charset)StandardCharsets.US_ASCII), headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN_US_ASCII).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.TEXT_PLAIN), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, StandardCharsets.US_ASCII));
    private static final int MAX_BYTES_PER_CHAR_UTF8 = (int)StandardCharsets.UTF_8.newEncoder().maxBytesPerChar();
    private static final HttpStreamingSerializerDeserializer<String> APP_STREAMING_FIX_LEN_UTF_8 = HttpSerializers.streamingSerializer(new FixedLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)StandardCharsets.UTF_8), str -> str.length() * MAX_BYTES_PER_CHAR_UTF8), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, APPLICATION_TEXT_FIXED_UTF_8).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_FIXED), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_FIXED, StandardCharsets.UTF_8));
    private static final HttpStreamingSerializerDeserializer<String> APP_STREAMING_FIX_LEN_ASCII = HttpSerializers.streamingSerializer(new FixedLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)StandardCharsets.US_ASCII), String::length), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, APPLICATION_TEXT_FIXED_US_ASCII).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_FIXED), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_FIXED, StandardCharsets.US_ASCII));
    private static final HttpStreamingSerializerDeserializer<String> APP_STREAMING_VAR_LEN_UTF_8 = HttpSerializers.streamingSerializer(new VarIntLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)StandardCharsets.UTF_8), str -> str.length() * MAX_BYTES_PER_CHAR_UTF8), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, APPLICATION_TEXT_VAR_INT_UTF_8).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_VARINT), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_VARINT, StandardCharsets.UTF_8));
    private static final HttpStreamingSerializerDeserializer<String> APP_STREAMING_VAR_LEN_ASCII = HttpSerializers.streamingSerializer(new VarIntLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)StandardCharsets.US_ASCII), String::length), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, APPLICATION_TEXT_VAR_INT_US_ASCII).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_VARINT), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_VARINT, StandardCharsets.US_ASCII));

    private HttpSerializers() {
    }

    public static HttpSerializerDeserializer<Map<String, List<String>>> formUrlEncodedSerializer() {
        return FORM_ENCODED_UTF_8;
    }

    public static HttpSerializerDeserializer<Map<String, List<String>>> formUrlEncodedSerializer(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return FORM_ENCODED_UTF_8;
        }
        CharSequence contentType = CharSequences.newAsciiString((CharSequence)(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED + "; charset=" + charset.name()));
        return new DefaultHttpSerializerDeserializer<Map<String, List<String>>>(new FormUrlEncodedSerializer(charset), headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, contentType).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, charset));
    }

    public static HttpSerializerDeserializer<String> textSerializerUtf8() {
        return TEXT_UTF_8;
    }

    public static HttpSerializerDeserializer<String> textSerializerAscii() {
        return TEXT_ASCII;
    }

    public static HttpSerializerDeserializer<String> textSerializer(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return TEXT_UTF_8;
        }
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return TEXT_ASCII;
        }
        CharSequence contentType = CharSequences.newAsciiString((CharSequence)("text/plain; charset=" + charset.name()));
        return new DefaultHttpSerializerDeserializer<String>(StringSerializer.stringSerializer((Charset)charset), headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, contentType).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.TEXT_PLAIN), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, charset));
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerUtf8FixLen() {
        return APP_STREAMING_FIX_LEN_UTF_8;
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerUtf8VarLen() {
        return APP_STREAMING_VAR_LEN_UTF_8;
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerAsciiFixLen() {
        return APP_STREAMING_FIX_LEN_ASCII;
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerAsciiVarLen() {
        return APP_STREAMING_VAR_LEN_ASCII;
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerFixLen(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return APP_STREAMING_FIX_LEN_UTF_8;
        }
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return APP_STREAMING_FIX_LEN_ASCII;
        }
        int maxBytesPerChar = (int)charset.newEncoder().maxBytesPerChar();
        CharSequence contentType = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_FIXED + "; charset=" + charset.name()));
        return HttpSerializers.streamingSerializer(new FixedLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)charset), str -> str.length() * maxBytesPerChar), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, contentType).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_FIXED), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_FIXED, charset));
    }

    public static HttpStreamingSerializerDeserializer<String> appSerializerVarLen(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return APP_STREAMING_VAR_LEN_UTF_8;
        }
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return APP_STREAMING_VAR_LEN_ASCII;
        }
        int maxBytesPerChar = (int)charset.newEncoder().maxBytesPerChar();
        CharSequence contentType = CharSequences.newAsciiString((CharSequence)(APPLICATION_TEXT_VARINT + "; charset=" + charset.name()));
        return HttpSerializers.streamingSerializer(new VarIntLengthStreamingSerializer(StringSerializer.stringSerializer((Charset)charset), str -> str.length() * maxBytesPerChar), (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, contentType).set(HttpHeaderNames.ACCEPT, APPLICATION_TEXT_VARINT), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, APPLICATION_TEXT_VARINT, charset));
    }

    public static HttpStreamingSerializer<String> stringStreamingSerializer(Charset charset, Consumer<HttpHeaders> headersSerializeConsumer) {
        int maxBytesPerChar = (int)charset.newEncoder().maxBytesPerChar();
        return HttpSerializers.streamingSerializer(StringSerializer.stringSerializer((Charset)charset), (T str) -> str.length() * maxBytesPerChar, headersSerializeConsumer);
    }

    public static HttpStreamingSerializer<byte[]> bytesStreamingSerializer(Consumer<HttpHeaders> headersSerializeConsumer) {
        return new DefaultHttpStreamingSerializer<byte[]>(NonFramedBytesStreamingSerializer.INSTANCE, headersSerializeConsumer);
    }

    public static <T> HttpSerializerDeserializer<T> jsonSerializer(SerializerDeserializer<T> serializer) {
        return new DefaultHttpSerializerDeserializer<T>(serializer, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_JSON).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_JSON, null));
    }

    public static <T> HttpStreamingSerializerDeserializer<T> jsonStreamingSerializer(StreamingSerializerDeserializer<T> serializer) {
        return new DefaultHttpStreamingSerializerDeserializer<T>(serializer, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_JSON).set(HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON), headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_JSON, null));
    }

    public static <T> HttpSerializerDeserializer<T> serializer(SerializerDeserializer<T> serializer, Consumer<HttpHeaders> headersSerializeConsumer, Predicate<HttpHeaders> headersDeserializePredicate) {
        return new DefaultHttpSerializerDeserializer<T>(serializer, headersSerializeConsumer, headersDeserializePredicate);
    }

    public static <T> HttpStreamingSerializerDeserializer<T> streamingSerializer(StreamingSerializerDeserializer<T> serializer, Consumer<HttpHeaders> headersSerializeConsumer, Predicate<HttpHeaders> headersDeserializePredicate) {
        return new DefaultHttpStreamingSerializerDeserializer<T>(serializer, headersSerializeConsumer, headersDeserializePredicate);
    }

    public static <T> HttpStreamingSerializer<T> streamingSerializer(Serializer<T> serializer, ToIntFunction<T> bytesEstimator, Consumer<HttpHeaders> headersSerializeConsumer) {
        return new DefaultHttpStreamingSerializer<T>(serializer, bytesEstimator, headersSerializeConsumer);
    }
}

