/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpOutputStream;
import io.servicetalk.http.api.HttpPayloadWriter;
import java.io.IOException;

final class HttpPayloadWriterToHttpOutputStream
extends HttpOutputStream {
    private final HttpPayloadWriter<Buffer> writer;
    private final BufferAllocator allocator;

    HttpPayloadWriterToHttpOutputStream(HttpPayloadWriter<Buffer> writer, BufferAllocator allocator) {
        this.writer = writer;
        this.allocator = allocator;
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(this.allocator.newBuffer(1).writeByte(b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writer.write(this.allocator.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.writer.write(this.allocator.wrap(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public HttpHeaders trailers() {
        return this.writer.trailers();
    }
}

