/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.Http2ErrorCode;
import java.io.IOException;
import java.util.Objects;

public class Http2Exception
extends IOException {
    private static final long serialVersionUID = -7412275553620283540L;
    private final int streamId;
    private final Http2ErrorCode error;

    public Http2Exception(int streamId, Http2ErrorCode error, String message) {
        super(message);
        this.streamId = Http2Exception.validateStreamId(streamId);
        this.error = Objects.requireNonNull(error);
    }

    public Http2Exception(int streamId, Http2ErrorCode error, Throwable cause) {
        super(cause);
        this.streamId = Http2Exception.validateStreamId(streamId);
        this.error = Objects.requireNonNull(error);
    }

    public Http2Exception(int streamId, Http2ErrorCode error, String message, Throwable cause) {
        super(message, cause);
        this.streamId = Http2Exception.validateStreamId(streamId);
        this.error = Objects.requireNonNull(error);
    }

    public final Http2ErrorCode errorCode() {
        return this.error;
    }

    public final int streamId() {
        return this.streamId;
    }

    private static int validateStreamId(int streamId) {
        if (streamId < 0) {
            throw new IllegalArgumentException("streamId: " + streamId + "(expected >=0)");
        }
        return streamId;
    }
}

