/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequests;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponses;
import java.util.Objects;

public final class DefaultStreamingHttpRequestResponseFactory
implements StreamingHttpRequestResponseFactory {
    private final BufferAllocator allocator;
    private final HttpHeadersFactory headersFactory;
    private final HttpProtocolVersion protocolVersion;

    public DefaultStreamingHttpRequestResponseFactory(BufferAllocator allocator, HttpHeadersFactory headersFactory, HttpProtocolVersion protocolVersion) {
        this.allocator = Objects.requireNonNull(allocator);
        this.headersFactory = Objects.requireNonNull(headersFactory);
        this.protocolVersion = Objects.requireNonNull(protocolVersion);
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return StreamingHttpRequests.newRequest(method, requestTarget, this.protocolVersion, this.headersFactory.newHeaders(), this.allocator, this.headersFactory);
    }

    @Override
    public StreamingHttpResponse newResponse(HttpResponseStatus status) {
        return StreamingHttpResponses.newResponse(status, this.protocolVersion, this.headersFactory.newHeaders(), this.allocator, this.headersFactory);
    }
}

