/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMessageBodyIterable;
import io.servicetalk.http.api.HttpMessageBodyIterator;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

final class BlockingStreamingHttpMessageBodyUtils {
    private BlockingStreamingHttpMessageBodyUtils() {
    }

    static HttpMessageBodyIterable<Buffer> newMessageBody(BlockingIterable<Object> rawMsgBody) {
        return () -> new DefaultHttpMessageBodyIterator(rawMsgBody.iterator());
    }

    static <T> HttpMessageBodyIterable<T> newMessageBody(final BlockingIterable<Object> rawMsgBody, final HttpHeaders headers, final HttpStreamingDeserializer<T> deserializer, final BufferAllocator allocator) {
        return () -> new HttpMessageBodyIterator<T>(){
            private final HttpMessageBodyIterator itr;
            private final BlockingIterator deserialized;
            {
                this.itr = new DefaultHttpMessageBodyIterator(rawMsgBody.iterator());
                this.deserialized = deserializer.deserialize(headers, (BlockingIterable<Buffer>)((BlockingIterable)() -> this.itr), allocator).iterator();
            }

            @Override
            @Nullable
            public HttpHeaders trailers() {
                return this.itr.trailers();
            }

            public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                return this.deserialized.hasNext(timeout, unit);
            }

            @Nullable
            public T next(long timeout, TimeUnit unit) throws TimeoutException {
                return this.deserialized.next(timeout, unit);
            }

            @Nullable
            public T next() {
                return this.deserialized.next();
            }

            public void close() throws Exception {
                this.deserialized.close();
            }

            public boolean hasNext() {
                return this.deserialized.hasNext();
            }
        };
    }

    private static final class DefaultHttpMessageBodyIterator<I>
    implements HttpMessageBodyIterator<Buffer> {
        private final BlockingIterator<I> rawMessageBody;
        @Nullable
        private HttpHeaders trailers;
        @Nullable
        private Buffer next;

        DefaultHttpMessageBodyIterator(BlockingIterator<I> rawMessageBody) {
            this.rawMessageBody = Objects.requireNonNull(rawMessageBody);
        }

        @Override
        @Nullable
        public HttpHeaders trailers() {
            return this.trailers;
        }

        public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
            if (this.next != null) {
                return true;
            }
            long remainingTimeoutNanos = unit.toNanos(timeout);
            long timeStampANanos = System.nanoTime();
            if (this.rawMessageBody.hasNext(remainingTimeoutNanos, TimeUnit.NANOSECONDS)) {
                this.setNext(this.rawMessageBody.next(remainingTimeoutNanos -= System.nanoTime() - timeStampANanos, TimeUnit.NANOSECONDS));
            }
            return this.next != null;
        }

        public Buffer next(long timeout, TimeUnit unit) {
            return this.next();
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.rawMessageBody.hasNext()) {
                this.setNext(this.rawMessageBody.next());
            }
            return this.next != null;
        }

        public Buffer next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Buffer tmp = this.next;
            this.next = null;
            return tmp;
        }

        public void remove() {
            this.rawMessageBody.remove();
        }

        public void close() throws Exception {
            this.rawMessageBody.close();
        }

        private void setNext(@Nullable Object rawNext) {
            if (rawNext instanceof Buffer) {
                this.next = (Buffer)rawNext;
            } else if (rawNext instanceof HttpHeaders) {
                this.trailers = (HttpHeaders)rawNext;
            } else if (rawNext != null) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException("exception while closing due to unsupported type: " + rawNext, e);
                }
                throw new IllegalArgumentException("unsupported type: " + rawNext);
            }
        }
    }
}

