/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.storage.shapefile.internal.DBaseFieldDescriptor;
import org.apache.baremaps.storage.shapefile.internal.DbaseByteReader;
import org.apache.baremaps.storage.shapefile.internal.ShapefileByteReader;
import org.apache.baremaps.storage.shapefile.internal.ShapefileDescriptor;
import org.apache.baremaps.storage.shapefile.internal.ShapefileException;

public class InputFeatureStream
extends InputStream {
    private DbaseByteReader dbaseReader;
    private File shapefile;
    private File databaseFile;
    private File shapefileIndex;
    private boolean hasShapefileIndex;
    private FeatureType featuresType;
    private ShapefileByteReader shapefileReader;

    public InputFeatureStream(File shapefile, File dbaseFile, File shpfileIndex) throws IOException {
        this.shapefile = shapefile;
        this.databaseFile = dbaseFile;
        this.dbaseReader = new DbaseByteReader(dbaseFile, null);
        if (shpfileIndex != null && shpfileIndex.exists() && shpfileIndex.isFile()) {
            this.shapefileIndex = shpfileIndex;
            this.hasShapefileIndex = true;
        } else {
            this.hasShapefileIndex = false;
        }
        this.shapefileReader = new ShapefileByteReader(this.shapefile, this.databaseFile, this.shapefileIndex);
        this.featuresType = this.shapefileReader.getFeaturesType();
    }

    public InputFeatureStream(File shpfile, File dbaseFile) throws IOException {
        this(shpfile, dbaseFile, null);
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("InputFeatureStream doesn't allow the use of read(). Use readFeature() instead.");
    }

    @Override
    public int available() {
        throw new UnsupportedOperationException("InputFeatureStream doesn't allow the use of available(). Use readFeature() will return null when feature are no more available.");
    }

    @Override
    public void close() {
    }

    public Feature readFeature() throws ShapefileException {
        return this.internalReadFeature();
    }

    public FeatureType getFeaturesType() {
        return this.featuresType;
    }

    public ShapefileDescriptor getShapefileDescriptor() {
        return this.shapefileReader.getShapefileDescriptor();
    }

    public List<DBaseFieldDescriptor> getDatabaseFieldsDescriptors() {
        return this.shapefileReader.getFieldsDescriptors();
    }

    public boolean hasShapefileIndex() {
        return this.hasShapefileIndex;
    }

    private Feature internalReadFeature() throws ShapefileException {
        if (!this.dbaseReader.nextRowAvailable()) {
            return null;
        }
        Feature feature = this.featuresType.newInstance();
        this.dbaseReader.loadRowIntoFeature(feature);
        this.shapefileReader.setRowNum(this.dbaseReader.getRowNum());
        this.shapefileReader.completeFeature(feature);
        return feature;
    }
}

