/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Info;
import org.locationtech.jts.geom.Geometry;

public final class Node
extends Element {
    private final double lon;
    private final double lat;

    public Node(long id, Info info, Map<String, Object> tags, double lon, double lat) {
        super(id, info, tags);
        this.lon = lon;
        this.lat = lat;
    }

    public Node(long id, Info info, Map<String, Object> tags, double lon, double lat, Geometry geometry) {
        super(id, info, tags, geometry);
        this.lon = lon;
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Node node = (Node)o;
        return Double.compare(node.lon, this.lon) == 0 && Double.compare(node.lat, this.lat) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lon, this.lat);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Node.class.getSimpleName() + "[", "]").add("lon=" + this.lon).add("lat=" + this.lat).add("id=" + this.id).toString();
    }
}

