/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.openstreetmap.model.Member;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.utils.GeometryUtils;
import org.apache.baremaps.stream.StreamException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationGeometryBuilder
implements Consumer<Relation> {
    private static final Logger logger = LoggerFactory.getLogger(RelationGeometryBuilder.class);
    private final DataMap<Coordinate> coordinateMap;
    private final DataMap<List<Long>> referenceMap;

    public RelationGeometryBuilder(DataMap<Coordinate> coordinateMap, DataMap<List<Long>> referenceMap) {
        this.coordinateMap = coordinateMap;
        this.referenceMap = referenceMap;
    }

    @Override
    public void accept(Relation relation) {
        try {
            Map<String, Object> tags = relation.getTags();
            if (!"multipolygon".equals(tags.get("type"))) {
                return;
            }
            if ("coastline".equals(tags.get("natural"))) {
                return;
            }
            Set<Polygon> outerPolygons = this.createPolygons(relation, "outer");
            Set<Polygon> innerPolygons = this.createPolygons(relation, "inner");
            List<Polygon> polygons = this.mergeOuterAndInnerPolygons(outerPolygons, innerPolygons = this.mergeInnerPolygons(innerPolygons));
            if (polygons.size() == 1) {
                Polygon polygon = polygons.get(0);
                relation.setGeometry((Geometry)polygon);
            } else if (polygons.size() > 1) {
                MultiPolygon multiPolygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createMultiPolygon(polygons.toArray(new Polygon[0]));
                relation.setGeometry((Geometry)multiPolygon);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to build the geometry for relation #" + relation.id(), (Throwable)e);
        }
    }

    private List<Polygon> mergeOuterAndInnerPolygons(Set<Polygon> outerPolygons, Set<Polygon> innerPolygons) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Polygon outerPolygon : outerPolygons) {
            LinearRing shell = outerPolygon.getExteriorRing();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            PreparedGeometry prepared = PreparedGeometryFactory.prepare((Geometry)outerPolygon);
            Iterator<Polygon> it = innerPolygons.iterator();
            while (it.hasNext()) {
                Polygon innerPolygon = it.next();
                if (!prepared.containsProperly((Geometry)innerPolygon)) continue;
                holes.add(innerPolygon.getExteriorRing());
                it.remove();
            }
            Polygon polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(shell, holes.toArray(new LinearRing[0]));
            polygons.add(polygon);
        }
        return polygons;
    }

    private Set<Polygon> mergeInnerPolygons(Set<Polygon> innerPolygons) {
        HashSet<Polygon> usedPolygons = new HashSet<Polygon>();
        HashSet<Polygon> mergedPolygons = new HashSet<Polygon>();
        for (Polygon p1 : innerPolygons) {
            if (usedPolygons.contains(p1)) continue;
            HashSet<Polygon> unionPolygons = new HashSet<Polygon>();
            unionPolygons.add(p1);
            for (Polygon p2 : innerPolygons) {
                if (p1.equals((Geometry)p2) || !p1.touches((Geometry)p2) && !p1.overlaps((Geometry)p2)) continue;
                unionPolygons.add(p2);
                usedPolygons.add(p2);
            }
            Geometry union = CascadedPolygonUnion.union(unionPolygons);
            for (Object polygon : PolygonExtracter.getPolygons((Geometry)union)) {
                mergedPolygons.add((Polygon)polygon);
            }
        }
        return mergedPolygons;
    }

    private Set<Polygon> createPolygons(Relation relation, String role) {
        HashSet<Polygon> polygons = new HashSet<Polygon>();
        LineMerger lineMerger = new LineMerger();
        relation.getMembers().stream().filter(m -> Member.MemberType.WAY.equals((Object)m.getType())).filter(m -> role.equals(m.getRole())).forEach(member -> {
            LineString line = this.createLine((Member)member);
            if (line.isClosed()) {
                Polygon polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(line.getCoordinates());
                polygons.add(polygon);
            } else {
                lineMerger.add((Geometry)line);
            }
        });
        lineMerger.getMergedLineStrings().stream().forEach(geometry -> {
            LineString line = (LineString)geometry;
            if (line.isClosed()) {
                Polygon polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(line.getCoordinates());
                polygons.add(polygon);
            }
        });
        return polygons;
    }

    private LineString createLine(Member member) {
        try {
            List refs = (List)this.referenceMap.get(member.getRef());
            List<Coordinate> coords = refs.stream().map(this.coordinateMap::get).toList();
            Coordinate[] array = coords.toArray(new Coordinate[coords.size()]);
            return GeometryUtils.GEOMETRY_FACTORY_WGS84.createLineString(array);
        }
        catch (Exception e) {
            throw new StreamException(e);
        }
    }
}

