/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder;

import java.util.Map;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GeonamesQueryBuilder {
    private final Analyzer analyzer;
    private String queryText;
    private String countryCode = "";

    public GeonamesQueryBuilder() {
        this(GeocoderConstants.ANALYZER);
    }

    public GeonamesQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public GeonamesQueryBuilder queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    public GeonamesQueryBuilder countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public Query build() {
        String countryCodeEsc;
        String queryTextEsc;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (this.queryText != null && !(queryTextEsc = QueryParser.escape((String)this.queryText)).isBlank()) {
            Map<String, Float> fieldWeights = Map.of("name", Float.valueOf(1.0f), "country", Float.valueOf(1.0f));
            Query termsQuery = new SimpleQueryParser(this.analyzer, fieldWeights).parse(queryTextEsc);
            builder.add(termsQuery, BooleanClause.Occur.SHOULD);
        }
        if (this.countryCode != null && !(countryCodeEsc = QueryParser.escape((String)this.countryCode)).isBlank()) {
            TermQuery countryCodeQuery = new TermQuery(new Term("countryCode", countryCodeEsc));
            builder.add((Query)countryCodeQuery, BooleanClause.Occur.MUST);
        }
        return builder.build();
    }
}

