/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;

public class FileTileStore
implements TileStore {
    private final Path path;

    public FileTileStore(Path path) {
        this.path = path;
    }

    @Override
    public ByteBuffer read(Tile tile) throws TileStoreException {
        try {
            return ByteBuffer.wrap(Files.readAllBytes(this.resolve(tile)));
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void write(Tile tile, ByteBuffer blob) throws TileStoreException {
        try {
            Path file = this.resolve(tile);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, blob.array(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void delete(Tile tile) throws TileStoreException {
        try {
            Files.deleteIfExists(this.resolve(tile));
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    public Path resolve(Tile tile) {
        return this.path.resolve(String.format("%s/%s/%s.mvt", tile.z(), tile.x(), tile.y()));
    }
}

