/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class LongListDataType
implements DataType<List<Long>> {
    @Override
    public int size(List<Long> values) {
        return 4 + values.size() * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Long> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (Long value : values) {
            buffer.putLong(position, value);
            position += 8;
        }
    }

    @Override
    public List<Long> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        ArrayList<Long> list = new ArrayList<Long>(size);
        for (int p = position + 4; p < position + size; p += 8) {
            list.add(buffer.getLong(p));
        }
        return list;
    }
}

