/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class FloatListDataType
implements DataType<List<Float>> {
    @Override
    public int size(List<Float> values) {
        return 4 + values.size() * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Float> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (Float value : values) {
            buffer.putFloat(position, value.floatValue());
            position += 4;
        }
    }

    @Override
    public List<Float> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        ArrayList<Float> list = new ArrayList<Float>(size);
        for (int p = position + 4; p < position + size; p += 4) {
            list.add(Float.valueOf(buffer.getFloat(p)));
        }
        return list;
    }
}

