/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.DataList;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.type.LongDataType;

public class IndexedDataList<E>
extends DataList<E> {
    private final DataList<Long> index;
    private final AppendOnlyBuffer<E> values;

    public IndexedDataList(AppendOnlyBuffer<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), values);
    }

    public IndexedDataList(DataList<Long> index, AppendOnlyBuffer<E> values) {
        this.index = index;
        this.values = values;
    }

    @Override
    public long addIndexed(E value) {
        long position = this.values.addPositioned(value);
        return this.index.addIndexed(position);
    }

    @Override
    public void set(long index, E value) {
        long position = this.values.addPositioned(value);
        this.index.set(index, position);
    }

    @Override
    public E get(long index) {
        long position = this.index.get(index);
        return this.values.read(position);
    }

    @Override
    public long sizeAsLong() {
        return this.index.sizeAsLong();
    }

    @Override
    public void clear() {
        this.index.clear();
        this.values.clear();
    }
}

