/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OptimizedHttp2FrameCodecBuilder
extends Http2FrameCodecBuilder {
    private static final Logger LOGGER;
    @Nullable
    private static final MethodHandle FLUSH_PREFACE;
    private final boolean server;
    private final int flowControlQuantum;

    OptimizedHttp2FrameCodecBuilder(boolean server, int flowControlQuantum) {
        this.server = server;
        this.flowControlQuantum = flowControlQuantum;
        OptimizedHttp2FrameCodecBuilder.disableFlushPreface(FLUSH_PREFACE, this);
    }

    public boolean isServer() {
        return this.server;
    }

    public Http2FrameCodec build() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        UniformStreamByteDistributor distributor = new UniformStreamByteDistributor((Http2Connection)connection);
        distributor.minAllocationChunk(this.flowControlQuantum);
        connection.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController((Http2Connection)connection, (StreamByteDistributor)distributor));
        this.connection((Http2Connection)connection);
        return super.build();
    }

    private static Http2FrameCodecBuilder disableFlushPreface(@Nullable MethodHandle flushPrefaceMethod, Http2FrameCodecBuilder builderInstance) {
        if (flushPrefaceMethod == null) {
            return builderInstance;
        }
        try {
            return flushPrefaceMethod.invokeExact(builderInstance, false);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException((Throwable)t);
            return builderInstance;
        }
    }

    static {
        MethodHandle flushPreface;
        LOGGER = LoggerFactory.getLogger(OptimizedHttp2FrameCodecBuilder.class);
        try {
            flushPreface = MethodHandles.publicLookup().findVirtual(Http2FrameCodecBuilder.class, "flushPreface", MethodType.methodType(Http2FrameCodecBuilder.class, Boolean.TYPE));
            OptimizedHttp2FrameCodecBuilder.disableFlushPreface(flushPreface, Http2FrameCodecBuilder.forClient());
        }
        catch (Throwable cause) {
            LOGGER.debug("Http2FrameCodecBuilder#flushPreface(boolean) is available only starting from Netty 4.1.78.Final. Detected Netty version: {}", (Object)Http2FrameCodecBuilder.class.getPackage().getImplementationVersion(), (Object)cause);
            flushPreface = null;
        }
        FLUSH_PREFACE = flushPreface;
    }
}

