/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnection;
import javax.annotation.Nullable;

final class NonPipelinedStreamingHttpConnection
extends AbstractStreamingHttpConnection<NettyConnection<Object, Object>> {
    NonPipelinedStreamingHttpConnection(NettyConnection<Object, Object> connection, HttpExecutionContext executionContext, StreamingHttpRequestResponseFactory reqRespFactory, HttpHeadersFactory headersFactory, boolean allowDropTrailersReadFromTransport) {
        super(connection, 1, executionContext, reqRespFactory, headersFactory, allowDropTrailersReadFromTransport);
    }

    @Override
    protected Publisher<Object> writeAndRead(Publisher<Object> requestStream, @Nullable FlushStrategy flushStrategy) {
        if (flushStrategy == null) {
            return ((NettyConnection)this.connection).write(requestStream).mergeDelayError(((NettyConnection)this.connection).read());
        }
        return Publisher.defer(() -> {
            Cancellable resetFlushStrategy = ((NettyConnection)this.connection).updateFlushStrategy((prev, isOriginal) -> isOriginal ? flushStrategy : prev);
            return ((NettyConnection)this.connection).write(requestStream).mergeDelayError(((NettyConnection)this.connection).read()).afterFinally(() -> ((Cancellable)resetFlushStrategy).cancel());
        });
    }
}

