/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMetaDataFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpObjectDecoder;
import io.servicetalk.http.netty.HttpResponseEncoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.utils.internal.IllegalCharacterException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Queue;

final class HttpRequestDecoder
extends HttpObjectDecoder<HttpRequestMetaData>
implements HttpResponseEncoder.OnResponse {
    private static final ByteProcessor FIND_WS_AFTER_METHOD_NAME = value -> {
        if (HttpRequestDecoder.isWS(value)) {
            return false;
        }
        HttpRequestDecoder.ensureVCHAR(value);
        return true;
    };
    private final Queue<HttpRequestMethod> methodQueue;
    private final CloseHandler closeHandler;
    private boolean expectContinue;
    private boolean seenPayloadBody;

    HttpRequestDecoder(Queue<HttpRequestMethod> methodQueue, ByteBufAllocator alloc, HttpHeadersFactory headersFactory, int maxStartLineLength, int maxHeaderFieldLength, boolean allowPrematureClosureBeforePayloadBody, boolean allowLFWithoutCR, CloseHandler closeHandler) {
        super(alloc, headersFactory, maxStartLineLength, maxHeaderFieldLength, allowPrematureClosureBeforePayloadBody, allowLFWithoutCR, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
        this.closeHandler = closeHandler;
    }

    @Override
    protected boolean isDecodingRequest() {
        return true;
    }

    @Override
    protected void handlePartialInitialLine(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            buffer.forEachByte(FIND_WS_AFTER_METHOD_NAME);
        }
        catch (IllegalCharacterException cause) {
            throw new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: must contain only visible characters", cause);
        }
    }

    private static void ensureVCHAR(byte value) {
        if (!HttpRequestDecoder.isVCHAR(value)) {
            throw new IllegalCharacterException(value, "VCHAR (0x21-0x7e)");
        }
    }

    @Override
    protected HttpRequestMetaData createMessage(ByteBuf buffer, int firstStart, int firstLength, int secondStart, int secondLength, int thirdStart, int thirdLength) {
        return HttpRequestMetaDataFactory.newRequestMetaData((HttpProtocolVersion)HttpRequestDecoder.nettyBufferToHttpVersion(buffer, thirdStart, thirdLength), (HttpRequestMethod)HttpRequestDecoder.decodeHttpMethod(buffer, firstStart, firstLength), (String)buffer.toString(secondStart, secondLength, StandardCharsets.US_ASCII), (HttpHeaders)this.headersFactory().newHeaders());
    }

    private static HttpRequestMethod decodeHttpMethod(ByteBuf buffer, int start, int length) {
        String methodName = buffer.toString(start, length, StandardCharsets.US_ASCII);
        HttpRequestMethod method = HttpRequestMethod.of((String)methodName);
        if (method != null) {
            return method;
        }
        try {
            return HttpRequestMethod.of((String)methodName, (HttpRequestMethod.Properties)HttpRequestMethod.Properties.NONE);
        }
        catch (IllegalArgumentException cause) {
            throw new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: HTTP request method must follow a valid token format", cause);
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpRequestMetaData msg) {
        this.methodQueue.add(msg.method());
        return false;
    }

    @Override
    protected boolean isInterim(HttpRequestMetaData msg) {
        return false;
    }

    @Override
    protected void onMetaDataRead(ChannelHandlerContext ctx, HttpRequestMetaData msg) {
        this.expectContinue = HeaderUtils.REQ_EXPECT_CONTINUE.test(msg);
    }

    @Override
    protected void onDataSeen() {
        this.seenPayloadBody = true;
    }

    @Override
    protected void resetNow() {
        super.resetNow();
        this.onStateReset();
    }

    private void onStateReset() {
        this.expectContinue = false;
        this.seenPayloadBody = false;
    }

    @Override
    public void onResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        if (this.expectContinue && !this.seenPayloadBody) {
            if (status == HttpResponseStatus.CONTINUE) {
                this.onStateReset();
            } else if (status.statusClass() != HttpResponseStatus.StatusClass.SUCCESSFUL_2XX && status.statusClass() != HttpResponseStatus.StatusClass.INFORMATIONAL_1XX) {
                this.closeHandler.protocolPayloadEndInbound(ctx);
                this.resetNow();
            }
        }
    }
}

