/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class HttpConfig {
    private final Consumer<H2ProtocolConfig> h2ConfigValidator;
    @Nullable
    private H1ProtocolConfig h1Config;
    @Nullable
    private H2ProtocolConfig h2Config;
    private List<String> supportedAlpnProtocols;
    private boolean allowDropTrailers;

    HttpConfig(Consumer<H2ProtocolConfig> h2ConfigValidator) {
        this.h2ConfigValidator = Objects.requireNonNull(h2ConfigValidator);
        this.h1Config = HttpProtocolConfigs.h1Default();
        this.h2Config = null;
        this.supportedAlpnProtocols = Collections.emptyList();
    }

    HttpConfig(HttpConfig from) {
        this.h2ConfigValidator = from.h2ConfigValidator;
        this.h1Config = from.h1Config;
        this.h2Config = from.h2Config;
        this.supportedAlpnProtocols = from.supportedAlpnProtocols;
        this.allowDropTrailers = from.allowDropTrailers;
    }

    @Nullable
    H1ProtocolConfig h1Config() {
        return this.h1Config;
    }

    @Nullable
    H2ProtocolConfig h2Config() {
        return this.h2Config;
    }

    List<String> supportedAlpnProtocols() {
        return this.supportedAlpnProtocols;
    }

    boolean allowDropTrailersReadFromTransport() {
        return this.allowDropTrailers;
    }

    void allowDropTrailersReadFromTransport(boolean allowDrop) {
        this.allowDropTrailers = allowDrop;
    }

    void protocols(HttpProtocolConfig ... protocols) {
        Objects.requireNonNull(protocols);
        if (protocols.length < 1) {
            throw new IllegalArgumentException("No protocols specified");
        }
        this.h1Config = null;
        this.h2Config = null;
        for (HttpProtocolConfig protocol : protocols) {
            if (protocol instanceof H1ProtocolConfig) {
                this.h1Config((H1ProtocolConfig)protocol);
                continue;
            }
            if (protocol instanceof H2ProtocolConfig) {
                this.h2Config((H2ProtocolConfig)protocol);
                continue;
            }
            throw new IllegalArgumentException("Unsupported HttpProtocolConfig: " + protocol.getClass().getName() + ", see " + HttpProtocolConfigs.class.getName());
        }
    }

    private void h1Config(H1ProtocolConfig h1Config) {
        if (this.h1Config != null) {
            throw new IllegalArgumentException("Duplicated configuration for HTTP/1.1 was found");
        }
        this.h1Config = h1Config;
        this.supportedAlpnProtocols = this.h2Config == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this.h2Config.alpnId(), h1Config.alpnId()));
    }

    private void h2Config(H2ProtocolConfig h2Config) {
        if (this.h2Config != null) {
            throw new IllegalArgumentException("Duplicated configuration for HTTP/2 was found");
        }
        this.h2ConfigValidator.accept(h2Config);
        this.h2Config = h2Config;
        this.supportedAlpnProtocols = this.h1Config == null ? Collections.singletonList(h2Config.alpnId()) : Collections.unmodifiableList(Arrays.asList(this.h1Config.alpnId(), h2Config.alpnId()));
    }
}

