/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.ogcapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariDataSource;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.database.PostgresUtils;
import org.apache.baremaps.ogcapi.ApiResource;
import org.apache.baremaps.ogcapi.CollectionsResource;
import org.apache.baremaps.ogcapi.ConformanceResource;
import org.apache.baremaps.ogcapi.ImportResource;
import org.apache.baremaps.ogcapi.RootResource;
import org.apache.baremaps.ogcapi.StudioResource;
import org.apache.baremaps.ogcapi.StylesResource;
import org.apache.baremaps.ogcapi.SwaggerResource;
import org.apache.baremaps.ogcapi.TilesetsResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.DefaultObjectMapper;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.jackson2.Jackson2Config;
import org.jdbi.v3.jackson2.Jackson2Plugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ogcapi", description={"OGC API server (experimental)."})
public class OgcApi
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(OgcApi.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of the Postgres database."}, required=true)
    private String database;
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ObjectMapper mapper = DefaultObjectMapper.defaultObjectMapper();
        mapper.readValue("", JsonNode.class);
        HikariDataSource datasource = PostgresUtils.dataSource((String)this.database);
        Jdbi jdbi = (Jdbi)Jdbi.create((DataSource)datasource).installPlugin((JdbiPlugin)new PostgresPlugin()).installPlugin((JdbiPlugin)new Jackson2Plugin()).configure(Jackson2Config.class, config -> config.setMapper(mapper));
        ResourceConfig application = new ResourceConfig().registerClasses(new Class[]{SwaggerResource.class, RootResource.class, CorsFilter.class, ConformanceResource.class, CollectionsResource.class, StylesResource.class, TilesetsResource.class, StudioResource.class, ImportResource.class, MultiPartFeature.class}).register((Object)new ApiResource("studio-openapi.yaml")).register((Object)ServiceTalkJacksonSerializerFeature.contextResolverFor((ObjectMapper)mapper)).register((Object)new AbstractBinder((DataSource)datasource, jdbi){
            final /* synthetic */ DataSource val$datasource;
            final /* synthetic */ Jdbi val$jdbi;
            {
                this.val$datasource = dataSource;
                this.val$jdbi = jdbi;
            }

            protected void configure() {
                this.bind(this.val$datasource).to(DataSource.class);
                this.bind(this.val$jdbi).to(Jdbi.class);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

