/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.cli.database.Database;
import org.apache.baremaps.cli.geocoder.Geocoder;
import org.apache.baremaps.cli.iploc.IpLoc;
import org.apache.baremaps.cli.map.Map;
import org.apache.baremaps.cli.ogcapi.OgcApi;
import org.apache.baremaps.cli.workflow.Workflow;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.bridge.SLF4JBridgeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="baremaps", description={"A toolkit for producing vector tiles."}, versionProvider=VersionProvider.class, subcommands={Workflow.class, Database.class, Map.class, Geocoder.class, IpLoc.class, OgcApi.class}, sortOptions=false)
public class Baremaps
implements Callable<Integer> {
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"Print version info."})
    boolean version;

    @Override
    public Integer call() {
        CommandLine.usage((Object)this, (PrintStream)System.out);
        return 0;
    }

    public static void main(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String level = "";
            if (arg.equals("--log-level") && i + 1 < args.length) {
                level = args[i + 1].strip();
            } else if (arg.startsWith("--log-level=")) {
                level = arg.substring(12).strip();
            }
            if ("".equals(level)) continue;
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            loggerConfig.setLevel(Level.getLevel((String)level));
            ctx.updateLoggers();
        }
        CommandLine cmd = new CommandLine((Object)new Baremaps()).setUsageHelpLongOptionsMaxWidth(30).addMixin("options", (Object)new Options());
        cmd.execute(args);
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            URL url = this.getClass().getResource("/version.txt");
            if (url == null) {
                return new String[]{"No version.txt file found in the classpath."};
            }
            try (InputStream inputStream = url.openStream();){
                Properties properties = new Properties();
                properties.load(inputStream);
                String[] stringArray = new String[]{properties.getProperty("application") + " v" + properties.getProperty("version")};
                return stringArray;
            }
        }
    }
}

