/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyPipelineSslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyPipelineSslUtils.class);

    private NettyPipelineSslUtils() {
    }

    public static boolean isSslEnabled(ChannelPipeline pipeline) {
        return pipeline.get(SslHandler.class) != null || pipeline.get(SniHandler.class) != null;
    }

    @Nullable
    public static SSLSession extractSslSessionAndReport(ChannelPipeline pipeline, SslHandshakeCompletionEvent sslEvent, Consumer<Throwable> failureConsumer, boolean shouldReport) {
        ConnectionObserver.SecurityHandshakeObserver observer;
        ConnectionObserver.SecurityHandshakeObserver securityHandshakeObserver = observer = shouldReport ? NettyPipelineSslUtils.handshakeObserver(pipeline) : null;
        if (sslEvent.isSuccess()) {
            SslHandler sslHandler = (SslHandler)pipeline.get(SslHandler.class);
            if (sslHandler != null) {
                SSLSession session = sslHandler.engine().getSession();
                if (observer != null) {
                    observer.handshakeComplete(session);
                }
                return session;
            }
            NettyPipelineSslUtils.deliverFailureCause(failureConsumer, new IllegalStateException("Unable to find " + SslHandler.class.getName() + " in the pipeline."), observer);
        } else {
            NettyPipelineSslUtils.deliverFailureCause(failureConsumer, sslEvent.cause(), observer);
        }
        return null;
    }

    private static void deliverFailureCause(Consumer<Throwable> failureConsumer, Throwable cause, @Nullable ConnectionObserver.SecurityHandshakeObserver securityObserver) {
        if (securityObserver != null) {
            securityObserver.handshakeFailed(cause);
        }
        failureConsumer.accept(cause);
    }

    @Nullable
    private static ConnectionObserver.SecurityHandshakeObserver handshakeObserver(ChannelPipeline pipeline) {
        ConnectionObserverInitializer.ConnectionObserverHandler handler = (ConnectionObserverInitializer.ConnectionObserverHandler)pipeline.get(ConnectionObserverInitializer.ConnectionObserverHandler.class);
        if (handler == null) {
            LOGGER.warn("Expected to report the handshake completion event, but unable to find {} in the pipeline.", ConnectionObserverInitializer.ConnectionObserverHandler.class);
            return null;
        }
        ConnectionObserver.SecurityHandshakeObserver handshakeObserver = handler.handshakeObserver();
        if (handshakeObserver == null) {
            LOGGER.warn("Expected to report the handshake completion event, but {} was not initialized.", ConnectionObserver.SecurityHandshakeObserver.class);
            return null;
        }
        return handshakeObserver;
    }
}

