/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.net.URI;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Singleton
public class BaseUriRequestFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriBuilder baseUri = UriBuilder.fromUri((URI)requestContext.getUriInfo().getBaseUri());
        MultivaluedMap headers = requestContext.getHeaders();
        if (headers.get((Object)"X-Forwarded-Proto") != null) {
            baseUri.scheme((String)headers.getFirst((Object)"X-Forwarded-Proto"));
        }
        if (headers.get((Object)"X-Forwarded-Host") != null) {
            baseUri.host((String)headers.getFirst((Object)"X-Forwarded-Host"));
        }
        if (headers.get((Object)"X-Forwarded-Port") != null) {
            baseUri.port(Integer.parseInt((String)headers.getFirst((Object)"X-Forwarded-Port")));
        }
        requestContext.setRequestUri(baseUri.build(new Object[0]), requestContext.getUriInfo().getRequestUri());
    }
}

